import 'dart:convert';

UsernameLupaPasswordRespon usernameLupaPasswordResponFromJson(String str) => UsernameLupaPasswordRespon.fromJson(json.decode(str));

String usernameLupaPasswordResponToJson(UsernameLupaPasswordRespon data) => json.encode(data.toJson());

class UsernameLupaPasswordRespon {
  bool? success;
  String? message;
  DataLupaPassword? dataLupaPassword;

  UsernameLupaPasswordRespon(
      {this.success, this.message, this.dataLupaPassword});

  UsernameLupaPasswordRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataLupaPassword = json['data_lupa_password'] != null
        ? new DataLupaPassword.fromJson(json['data_lupa_password'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataLupaPassword != null) {
      data['data_lupa_password'] = this.dataLupaPassword!.toJson();
    }
    return data;
  }
}

class DataLupaPassword {
  String? username;
  String? idKaryawan;
  String? idCompany;
  String? data;

  DataLupaPassword({this.username, this.idKaryawan, this.idCompany, this.data});

  DataLupaPassword.fromJson(Map<String, dynamic> json) {
    username = json['username'];
    idKaryawan = json['id_karyawan'];
    idCompany = json['id_company'];
    data = json['data'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['username'] = this.username;
    data['id_karyawan'] = this.idKaryawan;
    data['id_company'] = this.idCompany;
    data['data'] = this.data;
    return data;
  }
}
