// To parse this JSON data, do
//
//     final loginSsoRespon = loginSsoResponFromJson(jsonString);

import 'dart:convert';

LoginSsoRespon loginSsoResponFromJson(String str) => LoginSsoRespon.fromJson(json.decode(str));

String loginSsoResponToJson(LoginSsoRespon data) => json.encode(data.toJson());

class LoginSsoRespon {
    String? message;
    bool? success;
    DataLogin? dataLogin;

    LoginSsoRespon({
        this.message,
        this.success,
        this.dataLogin,
    });

    factory LoginSsoRespon.fromJson(Map<String, dynamic> json) => LoginSsoRespon(
        message: json["message"],
        success: json["success"],
        dataLogin: DataLogin.fromJson(json["data_login"]),
    );

    Map<String, dynamic> toJson() => {
        "message": message,
        "success": success,
        "data_login": dataLogin == null ? null : dataLogin!.toJson(),
    };
}

class DataLogin {
    String? odataContext;
    String? displayName;
    String? givenName;
    String? jobTitle;
    String? mail;
    String? mobilePhone;
    String? officeLocation;
    String? preferredLanguage;
    String? surname;
    String? userPrincipalName;
    String? id;

    DataLogin({
        this.odataContext,
        this.displayName,
        this.givenName,
        this.jobTitle,
        this.mail,
        this.mobilePhone,
        this.officeLocation,
        this.preferredLanguage,
        this.surname,
        this.userPrincipalName,
        this.id,
    });

    factory DataLogin.fromJson(Map<String, dynamic> json) => DataLogin(
        odataContext: json["@odata.context"],
        displayName: json["displayName"],
        givenName: json["givenName"],
        jobTitle: json["jobTitle"],
        mail: json["mail"],
        mobilePhone: json["mobilePhone"],
        officeLocation: json["officeLocation"],
        preferredLanguage: json["preferredLanguage"],
        surname: json["surname"],
        userPrincipalName: json["userPrincipalName"],
        id: json["id"],
    );

    Map<String, dynamic> toJson() => {
        "@odata.context": odataContext,
        "displayName": displayName,
        "givenName": givenName,
        "jobTitle": jobTitle,
        "mail": mail,
        "mobilePhone": mobilePhone,
        "officeLocation": officeLocation,
        "preferredLanguage": preferredLanguage,
        "surname": surname,
        "userPrincipalName": userPrincipalName,
        "id": id,
    };
}
