// To parse this JSON data, do
//
//     final reimbursementRespon = reimbursementResponFromJson(jsonString);

import 'dart:convert';

ReimbursementRespon reimbursementResponFromJson(String str) => ReimbursementRespon.fromJson(json.decode(str));

String reimbursementResponToJson(ReimbursementRespon data) => json.encode(data.toJson());

class ReimbursementRespon {
  ReimbursementRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataReimbursement>? data;

  factory ReimbursementRespon.fromJson(Map<String, dynamic> json) => ReimbursementRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    data: json["data"] == null ? null : List<DataReimbursement>.from(json["data"].map((x) => DataReimbursement.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": data == null ? null : List<dynamic>.from(data!.map((x) => x.toJson())),
  };
}

class DataReimbursement {
  DataReimbursement({
    this.idPengajuan,
    this.noPengajuan,
    this.tglPengajuan,
    this.jmlPengajuan,
    this.totalPengajuan,
    this.totalPengajuanDisetujui,
    this.namaKaryawan,
    this.namaDepartemen,
    this.namaCabang,
    this.aksiFooter,
    this.listApproval,
    this.listItemPengajuan,
    this.keterangan,
  });

  String? idPengajuan;
  String? noPengajuan;
  String? tglPengajuan;
  int? jmlPengajuan;
  String? totalPengajuan;
  String? totalPengajuanDisetujui;
  String? namaKaryawan;
  String? namaDepartemen;
  String? namaCabang;
  String? keterangan;
  bool? aksiFooter;
  List<ListApproval>? listApproval;
  ListItemPengajuan? listItemPengajuan;

  factory DataReimbursement.fromJson(Map<String, dynamic> json) => DataReimbursement(
    idPengajuan: json["id_pengajuan"] == null ? null : json["id_pengajuan"],
    noPengajuan: json["no_pengajuan"] == null ? null : json["no_pengajuan"],
    tglPengajuan: json["tgl_pengajuan"] == null ? null : json["tgl_pengajuan"],
    jmlPengajuan: json["jml_pengajuan"] == null ? null : json["jml_pengajuan"],
    totalPengajuan: json["total_pengajuan"] == null ? null : json["total_pengajuan"],
    totalPengajuanDisetujui: json["total_pengajuan_disetujui"] == null ? null : json["total_pengajuan_disetujui"],
    namaKaryawan: json["nama_karyawan"] == null ? null : json["nama_karyawan"],
    namaDepartemen: json["nama_departemen"] == null ? null : json["nama_departemen"],
    namaCabang: json["nama_cabang"] == null ? null : json["nama_cabang"],
    keterangan: json["keterangan"] == null ? null : json["keterangan"],
    aksiFooter: json["aksi_footer"] == null ? null : json["aksi_footer"],
    listApproval: json["list_approval"] == null ? null : List<ListApproval>.from(json["list_approval"].map((x) => ListApproval.fromJson(x))),
    listItemPengajuan: json["list_item_pengajuan"] == null ? null : ListItemPengajuan.fromJson(json["list_item_pengajuan"]),
  );

  Map<String, dynamic> toJson() => {
    "id_pengajuan": idPengajuan == null ? null : idPengajuan,
    "no_pengajuan": noPengajuan == null ? null : noPengajuan,
    "tgl_pengajuan": tglPengajuan == null ? null : tglPengajuan,
    "jml_pengajuan": jmlPengajuan == null ? null : jmlPengajuan,
    "total_pengajuan": totalPengajuan == null ? null : totalPengajuan,
    "total_pengajuan_disetujui": totalPengajuanDisetujui == null ? null : totalPengajuanDisetujui,
    "nama_karyawan": namaKaryawan == null ? null : namaKaryawan,
    "nama_departemen": namaDepartemen == null ? null : namaDepartemen,
    "nama_cabang": namaCabang == null ? null : namaCabang,
    "keterangan": keterangan == null ? null : keterangan,
    "aksi_footer": aksiFooter == null ? null : aksiFooter,
    "list_approval": listApproval == null ? null : List<dynamic>.from(listApproval!.map((x) => x.toJson())),
    "list_item_pengajuan": listItemPengajuan == null ? null : listItemPengajuan!.toJson(),
  };
}

class ListApproval {
  ListApproval({
    this.title,
    this.iconInfo,
    this.idStatus,
    this.informasiKeterangan,
    this.statusApproval,
    this.tanggalApproval,
    this.warnaStatus,
    this.warnaFont,
  });

  String? title;
  bool? iconInfo;
  String? idStatus;
  String? informasiKeterangan;
  String? statusApproval;
  DateTime? tanggalApproval;
  String? warnaStatus;
  String? warnaFont;

  factory ListApproval.fromJson(Map<String, dynamic> json) => ListApproval(
    title: json["title"] == null ? null : json["title"],
    iconInfo: json["icon_info"] == null ? null : json["icon_info"],
    idStatus: json["id_status"] == null ? null : json["id_status"],
    informasiKeterangan: json["informasi_keterangan"] == null ? null : json["informasi_keterangan"],
    statusApproval: json["status_approval"] == null ? null : json["status_approval"],
    tanggalApproval: json["tanggal_approval"] == null ? null : DateTime.parse(json["tanggal_approval"]),
    warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
    warnaFont: json["warna_font"] == null ? null : json["warna_font"],
  );

  Map<String, dynamic> toJson() => {
    "title": title == null ? null : title,
    "icon_info": iconInfo == null ? null : iconInfo,
    "id_status": idStatus == null ? null : idStatus,
    "informasi_keterangan": informasiKeterangan == null ? null : informasiKeterangan,
    "status_approval": statusApproval == null ? null : statusApproval,
    "tanggal_approval": tanggalApproval == null ? null : tanggalApproval!.toIso8601String(),
    "warna_status": warnaStatus == null ? null : warnaStatus,
    "warna_font": warnaFont == null ? null : warnaFont,
  };
}

class ListItemPengajuan {
  ListItemPengajuan({
    this.jumlah,
    this.dataItem,
  });

  int? jumlah;
  List<DataItem>? dataItem;

  factory ListItemPengajuan.fromJson(Map<String, dynamic> json) => ListItemPengajuan(
    jumlah: json["jumlah"] == null ? null : json["jumlah"],
    dataItem: json["data_item"] == null ? null : List<DataItem>.from(json["data_item"].map((x) => DataItem.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "jumlah": jumlah == null ? null : jumlah,
    "data_item": dataItem == null ? null : List<dynamic>.from(dataItem!.map((x) => x.toJson())),
  };
}

class DataItem {
  DataItem({
    this.idItem,
    this.idJenis,
    this.jenis,
    this.tglNota,
    this.tglNotaRaw,
    this.keterangan,
    this.nominal,
    this.nominalDisetujui,
    this.file,
    this.editedPhotoPath,
    this.maxNominalPlafon,
    this.aksi,
    this.tombolAksiRevisi,
    this.status,
    this.listApproval,
  });

  String? idItem;
  String? jenis;
  String? idJenis;
  String? tglNota;
  DateTime? tglNotaRaw;
  String? keterangan;
  int? nominal;
  int? nominalDisetujui;
  String? file;
  String? editedPhotoPath;
  int? maxNominalPlafon;
  bool? aksi;
  bool? tombolAksiRevisi;
  ListApproval? status;
  List<ListApproval>? listApproval;

  factory DataItem.fromJson(Map<String, dynamic> json) => DataItem(
    idItem: json["id_item"] == null ? null : json["id_item"],
    idJenis: json["id_jenis"] == null ? null : json["id_jenis"],
    jenis: json["jenis"] == null ? null : json["jenis"],
    tglNota: json["tgl_nota"] == null ? null : json["tgl_nota"],
    tglNotaRaw: json["tgl_nota_raw"] == null ? null : DateTime.parse(json["tgl_nota_raw"]),
    keterangan: json["keterangan"] == null ? null : json["keterangan"],
    nominal: json["nominal"] == null ? null : json["nominal"],
    nominalDisetujui: json["nominal_disetujui"] == null ? null : json["nominal_disetujui"],
    file: json["file"] == null ? null : json["file"],
    maxNominalPlafon: json["max_nominal_plafon"] == null ? null : json["max_nominal_plafon"],
    aksi: json["aksi"] == null ? null : json["aksi"],
    tombolAksiRevisi: json["tombol_aksi_revisi"] == null ? null : json["tombol_aksi_revisi"],
    status: json["status"] == null ? null : ListApproval.fromJson(json["status"]),
    listApproval: json["list_approval"] == null ? null : List<ListApproval>.from(json["list_approval"].map((x) => ListApproval.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "id_item": idItem == null ? null : idItem,
    "id_jenis": idJenis == null ? null : idJenis,
    "jenis": jenis == null ? null : jenis,
    "tgl_nota": tglNota == null ? null : tglNota,
    "tgl_nota_raw": tglNotaRaw == null ? null : "${tglNotaRaw!.year.toString().padLeft(4, '0')}-${tglNotaRaw!.month.toString().padLeft(2, '0')}-${tglNotaRaw!.day.toString().padLeft(2, '0')}",
    "keterangan": keterangan == null ? null : keterangan,
    "nominal": nominal == null ? null : nominal,
    "nominal_disetujui": nominalDisetujui == null ? null : nominalDisetujui,
    "file": file == null ? null : file,
    "max_nominal_plafon": maxNominalPlafon == null ? null : maxNominalPlafon,
    "aksi": aksi == null ? null : aksi,
    "tombol_aksi_revisi": tombolAksiRevisi == null ? null : tombolAksiRevisi,
    "status": status == null ? null : status!.toJson(),
    "list_approval": listApproval == null ? null : List<dynamic>.from(listApproval!.map((x) => x.toJson())),
  };
}






ReimbursementItemTempRespon reimbursementItemTempResponFromJson(String str) => ReimbursementItemTempRespon.fromJson(json.decode(str));

String reimbursementItemTempResponToJson(ReimbursementItemTempRespon data) => json.encode(data.toJson());

class ReimbursementItemTempRespon {
  ReimbursementItemTempRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  DataReimbursementItemTemp? data;

  factory ReimbursementItemTempRespon.fromJson(Map<String, dynamic> json) => ReimbursementItemTempRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    data: json["data"] == null ? null : DataReimbursementItemTemp.fromJson(json["data"]),
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": data == null ? null : data!.toJson(),
  };
}

class DataReimbursementItemTemp {
  DataReimbursementItemTemp({
    this.totalPengajuan,
    this.listItemTemp,
  });

  int? totalPengajuan;
  List<ListItemTemp>? listItemTemp;

  factory DataReimbursementItemTemp.fromJson(Map<String, dynamic> json) => DataReimbursementItemTemp(
    totalPengajuan: json["total_pengajuan"] == null ? null : json["total_pengajuan"],
    listItemTemp: json["list_item_temp"] == null ? null : List<ListItemTemp>.from(json["list_item_temp"].map((x) => ListItemTemp.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "total_pengajuan": totalPengajuan == null ? null : totalPengajuan,
    "list_item_temp": listItemTemp == null ? null : List<dynamic>.from(listItemTemp!.map((x) => x.toJson())),
  };
}

class ListItemTemp {
  ListItemTemp({
    this.id,
    this.jenisPlafon,
    this.idJenisPlafon,
    this.nominal,
    this.keterangan,
    this.tglBukti,
    this.tglBuktiRaw,
    this.file,
  });

  String? id;
  String? idJenisPlafon;
  String? jenisPlafon;
  int? nominal;
  String? keterangan;
  String? tglBukti;
  DateTime? tglBuktiRaw;
  String? file;

  factory ListItemTemp.fromJson(Map<String, dynamic> json) => ListItemTemp(
    id: json["id"] == null ? null : json["id"],
    idJenisPlafon: json["id_jenis_reimbursement"] == null ? null : json["id_jenis_reimbursement"],
    jenisPlafon: json["jenis_plafon"] == null ? null : json["jenis_plafon"],
    nominal: json["nominal"] == null ? null : json["nominal"],
    keterangan: json["keterangan"] == null ? null : json["keterangan"],
    tglBukti: json["tgl_bukti"] == null ? null : json["tgl_bukti"],
    tglBuktiRaw: json["tgl_bukti_raw"] == null ? null : DateTime.parse(json["tgl_bukti_raw"]),
    file: json["file"] == null ? null : json["file"],
  );

  Map<String, dynamic> toJson() => {
    "jenis_plafon": jenisPlafon == null ? null : jenisPlafon,
    "nominal": nominal == null ? null : nominal,
    "keterangan": keterangan == null ? null : keterangan,
    "tgl_bukti": tglBukti == null ? null : tglBukti,
    "tgl_bukti_raw": tglBuktiRaw == null ? null : "${tglBuktiRaw!.year.toString().padLeft(4, '0')}-${tglBuktiRaw!.month.toString().padLeft(2, '0')}-${tglBuktiRaw!.day.toString().padLeft(2, '0')}",
    "file": file == null ? null : file,
  };
}

class ApprovalReimbursementModel{
  String? id;
  String? nominal;
  String? keterangan;
  String? status;

  ApprovalReimbursementModel(this.id, this.status, {this.nominal, this.keterangan});
}

