// To parse this JSON data, do
//
//     final jadwalShift = jadwalShiftFromJson(jsonString);

import 'dart:convert';

JadwalShift jadwalShiftFromJson(String str) =>
    JadwalShift.fromJson(json.decode(str));

String jadwalShiftToJson(JadwalShift data) => json.encode(data.toJson());

class JadwalShift {
  bool? success;
  String? message;
  Data? data;

  JadwalShift({
    this.success,
    this.message,
    this.data,
  });

  factory JadwalShift.fromJson(Map<String, dynamic> json) => JadwalShift(
        success: json["success"],
        message: json["message"],
        data: Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data!.toJson(),
      };
}

class Data {
  JadwalShiftDefault? jadwalShift;
  List<DataShift>? dataShift;

  Data({
    this.jadwalShift,
    this.dataShift,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        jadwalShift: JadwalShiftDefault.fromJson(json["jadwal_shift"]),
        dataShift: List<DataShift>.from(
            json["data_shift"].map((x) => DataShift.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "jadwal_shift": jadwalShift!.toJson(),
        "data_shift": List<dynamic>.from(dataShift!.map((x) => x.toJson())),
      };
}

class DataShift {
  String? idMasterShift;
  String? kodeShift;
  String? namaShift;
  String? jamMasuk;
  String? jamPulang;
  int? toleransiTerlambat;
  String? startAbsenMasuk;
  String? batasAbsenPulang;
  String? flagBatasAbsenPulang;
  String? libur;
  String? attStatus;
  String? attNote;
  bool? button;
  bool? active;

  DataShift({
    this.idMasterShift,
    this.kodeShift,
    this.namaShift,
    this.jamMasuk,
    this.jamPulang,
    this.toleransiTerlambat,
    this.startAbsenMasuk,
    this.batasAbsenPulang,
    this.flagBatasAbsenPulang,
    this.libur,
    this.attStatus,
    this.attNote,
    this.button,
    this.active,
  });

  factory DataShift.fromJson(Map<String, dynamic> json) => DataShift(
        idMasterShift: json["id_master_shift"],
        kodeShift: json["kode_shift"],
        namaShift: json["nama_shift"],
        jamMasuk: json["jam_masuk"],
        jamPulang: json["jam_pulang"],
        toleransiTerlambat: json["toleransi_terlambat"],
        startAbsenMasuk: json["start_absen_masuk"],
        batasAbsenPulang: json["batas_absen_pulang"],
        flagBatasAbsenPulang: json["flag_batas_absen_pulang"],
        libur: json["libur"],
        attStatus: json["att_status"],
        attNote: json["att_note"],
        button: json["button"],
        active :json["active"]
      );

  Map<String, dynamic> toJson() => {
        "id_master_shift": idMasterShift,
        "kode_shift": kodeShift,
        "nama_shift": namaShift,
        "jam_masuk": jamMasuk,
        "jam_pulang": jamPulang,
        "toleransi_terlambat": toleransiTerlambat,
        "start_absen_masuk": startAbsenMasuk,
        "batas_absen_pulang": batasAbsenPulang,
        "flag_batas_absen_pulang": flagBatasAbsenPulang,
        "libur": libur,
        "att_status": attStatus,
        "att_note": attNote,
        "button": button,
        "active":active
      };
}

class JadwalShiftDefault {
  bool? status;
  DataShift? jadwalDefault;

  JadwalShiftDefault({
    this.status,
    this.jadwalDefault,
  });

  factory JadwalShiftDefault.fromJson(Map<String, dynamic> json) =>
      JadwalShiftDefault(
        status: json["status"],
        jadwalDefault: json["jadwal_default"] != null
            ? DataShift.fromJson(json["jadwal_default"])
            : null,
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "jadwal_default":
            jadwalDefault != null ? jadwalDefault!.toJson() : null,
      };
}
