// To parse this JSON data, do
//
//     final datanotif = datanotifFromJson(jsonString);

import 'dart:convert';

Datanotif datanotifFromJson(String str) => Datanotif.fromJson(json.decode(str));

String datanotifToJson(Datanotif data) => json.encode(data.toJson());

class Datanotif {
  bool? success;
  String? message;
  List<Data>? data;

  Datanotif({
    this.success,
    this.message,
    this.data,
  });

  factory Datanotif.fromJson(Map<String, dynamic> json) => Datanotif(
        success: json["success"],
        message: json["message"],
        data: List<Data>.from(json["data"].map((x) => Data.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Data {
  String? idNotif;
  String? idKaryawan;
  String? idRef;
  String? rute;
  String? ketNotif;
  String? jenis;
  int? tglNotif;
  String? flagBaca;
  bool? ignore;


  Data({
    this.idNotif,
    this.idKaryawan,
    this.idRef,
    this.rute,
    this.ketNotif,
    this.jenis,
    this.tglNotif,
    this.flagBaca,
    this.ignore
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        idNotif: json["id_notif"],
        idKaryawan: json["id_karyawan"],
        idRef: json["id_ref"],
        rute: json["rute"],
        ketNotif: json["ket_notif"],
        jenis: json["jenis"],
        tglNotif: json["tgl_notif"],
        flagBaca: json["flag_baca"],
        ignore: json["ignore"]
      );

  Map<String, dynamic> toJson() => {
        "id_notif": idNotif,
        "id_karyawan": idKaryawan,
        "id_ref": idRef,
        "rute": rute,
        "ket_notif": ketNotif,
        "jenis": jenis,
        "tgl_notif": tglNotif,
        "flag_baca": flagBaca,
        "ignore": ignore
      };
}
