// To parse this JSON data, do
//
//     final absensiHariIniRespon = absensiHariIniResponFromJson(jsonString);

import 'dart:convert';

AbsensiHariIniRespon absensiHariIniResponFromJson(String str) =>
    AbsensiHariIniRespon.fromJson(json.decode(str));

String absensiHariIniResponToJson(AbsensiHariIniRespon data) =>
    json.encode(data.toJson());

class AbsensiHariIniRespon {
  AbsensiHariIniRespon({this.status, this.data, this.message});

  bool? status;
  Data? data;
  String? message;

  factory AbsensiHariIniRespon.fromJson(Map<String, dynamic> json) =>
      AbsensiHariIniRespon(
        status: json["status"] == null ? null : json["status"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "status": status == null ? null : status,
        "data": data == null ? null : data!.toJson(),
      };
}

class Data {
  Data({
    this.lokasi,
    this.dataAbsensi,
    this.jadwalAbsensi,
    this.statusButtonAbsensi,
    this.fleksible_jam_kerja,
    this.buttonAbsensiMasuk,
    this.buttonAbsensiPulang,
    this.waktu,
  });

  Lokasi? lokasi;
  DataAbsensi? dataAbsensi;
  JadwalAbsensi? jadwalAbsensi;
  StatusButtonAbsensi? statusButtonAbsensi;
  bool? fleksible_jam_kerja;
  ButtonAbsensiMasukClass? buttonAbsensiMasuk;
  ButtonAbsensiMasukClass? buttonAbsensiPulang;
  Waktu? waktu;

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        lokasi: json["lokasi"] == null ? null : Lokasi.fromJson(json["lokasi"]),
        dataAbsensi: json["data_absensi"] == null
            ? null
            : DataAbsensi.fromJson(json["data_absensi"]),
        jadwalAbsensi: json["jadwal_absensi"] == null
            ? null
            : JadwalAbsensi.fromJson(json["jadwal_absensi"]),
        statusButtonAbsensi: json["button_absensi"] == null
            ? null
            : StatusButtonAbsensi.fromJson(json["button_absensi"]),
        fleksible_jam_kerja: json["flexible_jam_kerja"],
        buttonAbsensiMasuk:
            ButtonAbsensiMasukClass.fromJson(json["button_absensi_masuk"]),
        buttonAbsensiPulang:
            ButtonAbsensiMasukClass.fromJson(json["button_absensi_pulang"]),
        waktu: Waktu.fromJson(json["waktu"]),
      );

  Map<String, dynamic> toJson() => {
        "lokasi": lokasi == null ? null : lokasi!.toJson(),
        "data_absensi": dataAbsensi == null ? null : dataAbsensi!.toJson(),
        "jadwal_absensi":
            jadwalAbsensi == null ? null : jadwalAbsensi!.toJson(),
        "button_absensi":
            statusButtonAbsensi == null ? null : statusButtonAbsensi!.toJson(),
        "flexible_jam_kerja": fleksible_jam_kerja,
        "button_absensi_masuk": buttonAbsensiMasuk!.toJson(),
        "button_absensi_pulang": buttonAbsensiPulang!.toJson(),
        "waktu": waktu!.toJson(),

      };
}

class ButtonAbsensiMasukClass {
  bool? buttonStatus;

  ButtonAbsensiMasukClass({
    this.buttonStatus,
  });

  factory ButtonAbsensiMasukClass.fromJson(Map<String, dynamic> json) =>
      ButtonAbsensiMasukClass(
        buttonStatus: json["button_status"],
      );

  Map<String, dynamic> toJson() => {
        "button_status": buttonStatus,
      };
}

class Waktu {
  String? currentDate;
  String? currentTime;
  String? dayNow;

  Waktu({
    this.currentDate,
    this.currentTime,
    this.dayNow,
  });

  factory Waktu.fromJson(Map<String, dynamic> json) => Waktu(
        currentDate: json["current_time"],
        currentTime: json["current_time"],
        dayNow: json["day_now"],
      );

  Map<String, dynamic> toJson() => {
        "current_date": currentDate,
        "current_time": currentTime,
        "day_now": dayNow,
      };
}

class StatusButtonAbsensi {
  StatusButtonAbsensi(
      {this.toggleAbsenKerja,
      this.enabledAbsenKerja,
      this.toggleAbsenIstirahat,
      this.enabledAbsenIstirahat,
      this.kondisi,
      this.keteranganButton});

  bool? toggleAbsenKerja;
  bool? enabledAbsenKerja;
  bool? toggleAbsenIstirahat;
  bool? enabledAbsenIstirahat;
  String? kondisi;
  String? keteranganButton;

  factory StatusButtonAbsensi.fromJson(Map<String, dynamic> json) =>
      StatusButtonAbsensi(
        toggleAbsenKerja: json["toggle_absen_kerja"] == null
            ? null
            : json["toggle_absen_kerja"],
        enabledAbsenKerja: json["enabled_absen_kerja"] == null
            ? null
            : json["enabled_absen_kerja"],
        toggleAbsenIstirahat: json["toggle_absen_istirahat"] == null
            ? null
            : json["toggle_absen_istirahat"],
        enabledAbsenIstirahat: json["enabled_absen_istirahat"] == null
            ? null
            : json["enabled_absen_istirahat"],
        kondisi: json["kondisi"] == null ? null : json["kondisi"],
        keteranganButton: json["keterangan_button"] == null
            ? null
            : json["keterangan_button"],
      );

  Map<String, dynamic> toJson() => {
        "toggle_absen_kerja":
            toggleAbsenKerja == null ? null : toggleAbsenKerja,
        "enabled_absen_kerja":
            enabledAbsenKerja == null ? null : enabledAbsenKerja,
        "toggle_absen_istirahat":
            toggleAbsenIstirahat == null ? null : toggleAbsenIstirahat,
        "enabled_absen_istirahat":
            enabledAbsenIstirahat == null ? null : enabledAbsenIstirahat,
        "kondisi": kondisi == null ? null : kondisi,
      };
}

class DataAbsensi {
  DataAbsensi(
      {this.jamMasuk,
      this.jamPulang,
      this.istirahatMulai,
      this.istirahatSelesai,
      this.idKaryawan,
      this.idCompany,
      this.idCabang,
      this.jenisAbsen,
      this.lokasiAbsen,
      this.latitude,
      this.longitude,
      this.tipeAbsen,
      this.kodeAbsen,
      this.ketKodeAbsen,
      this.jamKerja,
      this.keteranganAbsen,
      this.foto,
      this.tglJadwalAbsensi,
      this.idMasterShift,
      this.fleksible_jam_kerja,
      this.shiftSebelumnya});

  String? jamMasuk;
  String? jamPulang;
  String? istirahatMulai;
  String? istirahatSelesai;
  String? idKaryawan;
  String? idCompany;
  String? idCabang;
  String? jenisAbsen; // MASUK / PULANG / IST / DLL
  String? lokasiAbsen; // NAMA KANTORNYA
  String? latitude;
  String? longitude;
  String? tipeAbsen; // REG / LIBUR
  String? kodeAbsen; //H / I / C / DLL
  String? ketKodeAbsen; //Hadir / Izin / DLL
  String? jamKerja; // jam masuk - pulang
  String? keteranganAbsen;
  String? foto;
  String? tglJadwalAbsensi;
  String? idMasterShift;
  bool? fleksible_jam_kerja;
  String? shiftSebelumnya;

  factory DataAbsensi.fromJson(Map<String, dynamic> json) => DataAbsensi(
        jamMasuk: json["jam_masuk"] == null ? null : json["jam_masuk"],
        jamPulang: json["jam_pulang"] == null ? null : json["jam_pulang"],
        istirahatMulai:
            json["istirahat_mulai"] == null ? null : json["istirahat_mulai"],
        istirahatSelesai: json["istirahat_selesai"] == null
            ? null
            : json["istirahat_selesai"],
      );

  Map<String, dynamic> toJson() => {
        "jam_masuk": jamMasuk == null ? null : jamMasuk,
        "jam_pulang": jamPulang == null ? null : jamPulang,
        "istirahat_mulai": istirahatMulai == null ? null : istirahatMulai,
        "istirahat_selesai": istirahatSelesai == null ? null : istirahatSelesai,
      };
}

class JadwalAbsensi {
  JadwalAbsensi({
    this.status,
    this.jenisJamKerja,
    this.jamKerja,
  });

  bool? status;
  String? jenisJamKerja;
  JamKerja? jamKerja;

  factory JadwalAbsensi.fromJson(Map<String, dynamic> json) => JadwalAbsensi(
        status: json["status"] == null ? null : json["status"],
        jenisJamKerja:
            json["jenis_jam_kerja"] == null ? null : json["jenis_jam_kerja"],
        jamKerja: json["jam_kerja"] == null
            ? null
            : JamKerja.fromJson(json["jam_kerja"]),
      );

  Map<String, dynamic> toJson() => {
        "status": status == null ? null : status,
        "jenis_jam_kerja": jenisJamKerja == null ? null : jenisJamKerja,
        "jam_kerja": jamKerja == null ? null : jamKerja!.toJson(),
      };
}

class JamKerja {
  JamKerja(
      {this.jamMasuk,
      this.jamPulang,
      this.startAbsensiMasuk,
      this.batasAbsensiPulang,
      this.keterangan,
      this.kodeAbsensi,
      this.ketKode,
      this.tanggal,
      this.liburShift,
      this.tglJadwalAbsensi,
      this.idMasterShift});

  String? ketKode;
  String? kodeAbsensi;
  String? jamMasuk;
  String? jamPulang;
  String? startAbsensiMasuk;
  String? batasAbsensiPulang;
  String? keterangan;
  String? tanggal;
  String? liburShift;
  String? tglJadwalAbsensi;
  String? idMasterShift;

  factory JamKerja.fromJson(Map<String, dynamic> json) => JamKerja(
        jamMasuk: json["jam_masuk"] == null ? null : json["jam_masuk"],
        jamPulang: json["jam_pulang"] == null ? null : json["jam_pulang"],
        startAbsensiMasuk: json["start_absensi_masuk"] == null
            ? null
            : json["start_absensi_masuk"],
        batasAbsensiPulang: json["batas_absensi_pulang"] == null
            ? null
            : json["batas_absensi_pulang"],
        keterangan: json["keterangan"] == null ? null : json["keterangan"],
        ketKode: json["ket_kode"] == null ? null : json["ket_kode"],
        kodeAbsensi: json["kode_absensi"] == null ? null : json["kode_absensi"],
        tanggal: json["tanggal"] == null ? null : json["tanggal"],
        liburShift: json["libur_shift"] == null ? null : json["libur_shift"],
        tglJadwalAbsensi: json["tgl_jadwal_absensi"] == null
            ? null
            : json["tgl_jadwal_absensi"],
        idMasterShift:
            json["id_master_shift"] == null ? null : json["id_master_shift"],
      );

  Map<String, dynamic> toJson() => {
        "jam_masuk": jamMasuk == null ? null : jamMasuk,
        "jam_pulang": jamPulang == null ? null : jamPulang,
        "start_absensi_masuk":
            startAbsensiMasuk == null ? null : startAbsensiMasuk,
        "batas_absensi_pulang":
            batasAbsensiPulang == null ? null : batasAbsensiPulang,
        "keterangan": keterangan == null ? null : keterangan,
        "libur_shift": liburShift == null ? null : liburShift,
      };
}

class Lokasi {
  Lokasi(
      {this.status,
      this.lockLokasi,
      this.bolehAbsen,
      this.idLok,
      this.namaLokasi,
      this.ketLokasi,
      this.lokasiKantor});

  bool? status;
  bool? lockLokasi;
  bool? bolehAbsen;
  String? idLok;
  String? namaLokasi;
  String? ketLokasi;
  bool? lokasiKantor;

  factory Lokasi.fromJson(Map<String, dynamic> json) => Lokasi(
        status: json["status"] == null ? null : json["status"],
        lockLokasi: json["lock_lokasi"] == null ? null : json["lock_lokasi"],
        bolehAbsen: json["boleh_absen"] == null ? null : json["boleh_absen"],
        idLok: json["id_lok"] == null ? null : json["id_lok"],
        namaLokasi: json["nama_lokasi"] == null ? null : json["nama_lokasi"],
        ketLokasi: json["ket_lokasi"] == null ? null : json["ket_lokasi"],
        lokasiKantor:
            json["lokasi_kantor"] == null ? null : json["lokasi_kantor"],
      );

  Map<String, dynamic> toJson() => {
        "status": status == null ? null : status,
        "lock_lokasi": lockLokasi == null ? null : lockLokasi,
        "boleh_absen": bolehAbsen == null ? null : bolehAbsen,
        "id_lok": idLok == null ? null : idLok,
        "nama_lokasi": namaLokasi == null ? null : namaLokasi,
        "lokasi_kantor": lokasiKantor == null ? null : lokasiKantor,
      };
}

RekapAbsensiRespon rekapAbsensiResponFromJson(String str) =>
    RekapAbsensiRespon.fromJson(json.decode(str));

String rekapAbsensiResponToJson(RekapAbsensiRespon data) =>
    json.encode(data.toJson());

class RekapAbsensiRespon {
  RekapAbsensiRespon({
    this.success,
    this.data,
  });

  bool? success;
  List<DataRekapAbsensi>? data;

  factory RekapAbsensiRespon.fromJson(Map<String, dynamic> json) =>
      RekapAbsensiRespon(
        success: json["success"] == null ? null : json["success"],
        data: json["data"] == null
            ? null
            : List<DataRekapAbsensi>.from(
                json["data"].map((x) => DataRekapAbsensi.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataRekapAbsensi {
  DataRekapAbsensi({
    this.tglAbsensi,
    this.hariAbsensi,
    this.absenMasuk,
    this.absenPulang,
    this.terlambat,
    this.keteranganMasuk,
    this.keteranganPulang,
    this.keteranganIstirahatMulai,
    this.keteranganIstirahatSelesai,
    this.istMulai,
    this.istSelesai,
    this.jamPulang,
    this.kodeAbsensi,
    this.ketKode,
    this.jenisAbsensi,
    this.labelMasukPulang,
    this.fotoMasuk,
    this.fotoPulang,
    this.fotoIstMulai,
    this.fotoIstSelesai,
    this.namaDepartemen,
    this.namaCabang,
    this.namaKaryawan,
    this.idKaryawan,
    this.warna,
    this.latMasuk,
    this.longMasuk,
    this.latIstMulai,
    this.longIstMulai,
    this.latIstSelesai,
    this.longIstSelesai,
    this.latPulang,
    this.longPulang,
    this.jadwal,
    this.karyawan,
    this.jadwalAbsensi,
    this.absensiMasuk,
    this.absensiPulang,
    this.istirahatMulai,
    this.istirahatSelesai,
  });

  String? tglAbsensi;
  String? hariAbsensi;
  String? absenMasuk;
  String? absenPulang;
  int? terlambat;
  String? keteranganMasuk;
  String? keteranganPulang;
  String? keteranganIstirahatMulai;
  String? keteranganIstirahatSelesai;
  String? istMulai;
  String? istSelesai;
  DateTime? jamPulang;
  List<KodeAbsensi>? kodeAbsensi;
  String? ketKode;
  String? jenisAbsensi;
  bool? labelMasukPulang;
  String? fotoMasuk;
  String? fotoPulang;
  String? fotoIstMulai;
  String? fotoIstSelesai;
  String? namaCabang;
  String? namaDepartemen;
  String? namaKaryawan;
  String? idKaryawan;
  Warna? warna;
  String? latMasuk;
  String? longMasuk;
  String? latIstMulai;
  String? longIstMulai;
  String? latIstSelesai;
  String? longIstSelesai;
  String? latPulang;
  String? longPulang;
  String? jadwal;
  KaryawanV2? karyawan;
  JadwalAbsensiV2? jadwalAbsensi;
  DataAbsenV2? absensiMasuk;
  DataAbsenV2? absensiPulang;
  DataAbsenV2? istirahatMulai;
  DataAbsenV2? istirahatSelesai;

  factory DataRekapAbsensi.fromJson(Map<String, dynamic> json) =>
      DataRekapAbsensi(
        tglAbsensi: json["tgl_absensi"] == null ? null : json["tgl_absensi"],
        hariAbsensi: json["hari_absensi"] == null ? null : json["hari_absensi"],
        absenMasuk: json["absen_masuk"] == null ? null : json["absen_masuk"],
        absenPulang: json["absen_pulang"] == null ? null : json["absen_pulang"],
        terlambat: json["terlambat"] == null ? null : json["terlambat"],
        keteranganMasuk:
            json["keterangan_masuk"] == null ? null : json["keterangan_masuk"],
        keteranganPulang: json["keterangan_pulang"] == null
            ? null
            : json["keterangan_pulang"],
        keteranganIstirahatMulai: json["keterangan_istirahat_mulai"] == null
            ? null
            : json["keterangan_istirahat_mulai"],
        keteranganIstirahatSelesai: json["keterangan_istirahat_selesai"] == null
            ? null
            : json["keterangan_istirahat_selesai"],
        istMulai: json["ist_mulai"] == null ? null : json["ist_mulai"],
        istSelesai: json["ist_selesai"] == null ? null : json["ist_selesai"],
        jamPulang: json["jam_pulang"] == null
            ? null
            : DateTime.parse(json["jam_pulang"]),
        kodeAbsensi: json["kode_absensi"] == null
            ? null
            : List<KodeAbsensi>.from(
                json["kode_absensi"].map((x) => KodeAbsensi.fromJson(x))),
        ketKode: json["ket_kode"] == null ? null : json["ket_kode"],
        jenisAbsensi:
            json["jenis_absensi"] == null ? null : json["jenis_absensi"],
        labelMasukPulang: json["label_masuk_pulang"] == null
            ? null
            : json["label_masuk_pulang"],
        fotoMasuk: json["foto_masuk"] == null ? null : json["foto_masuk"],
        fotoPulang: json["foto_pulang"] == null ? null : json["foto_pulang"],
        fotoIstMulai:
            json["foto_ist_mulai"] == null ? null : json["foto_ist_mulai"],
        fotoIstSelesai:
            json["foto_ist_selesai"] == null ? null : json["foto_ist_selesai"],
        namaCabang: json["nama_cabang"] == null ? null : json["nama_cabang"],
        namaKaryawan:
            json["nama_karyawan"] == null ? null : json["nama_karyawan"],
        idKaryawan: json["id_karyawan"] == null ? null : json["id_karyawan"],
        namaDepartemen:
            json["nama_departemen"] == null ? null : json["nama_departemen"],
        warna: json["warna"] == null ? null : Warna.fromJson(json["warna"]),
        latMasuk: json["lat_masuk"] == null ? null : json["lat_masuk"],
        longMasuk: json["long_masuk"] == null ? null : json["long_masuk"],
        latIstMulai:
            json["lat_ist_mulai"] == null ? null : json["lat_ist_mulai"],
        longIstMulai:
            json["long_ist_mulai"] == null ? null : json["long_ist_mulai"],
        latIstSelesai:
            json["lat_ist_selesai"] == null ? null : json["lat_ist_selesai"],
        longIstSelesai:
            json["long_ist_selesai"] == null ? null : json["long_ist_selesai"],
        latPulang: json["lat_pulang"] == null ? null : json["lat_pulang"],
        longPulang: json["long_pulang"] == null ? null : json["long_pulang"],
        jadwal: json["jadwal"] == null ? null : json["jadwal"],
        karyawan: json["karyawan"] == null
            ? null
            : KaryawanV2.fromJson(json["karyawan"]),
        jadwalAbsensi: json["jadwal_absensi"] == null
            ? null
            : JadwalAbsensiV2.fromJson(json["jadwal_absensi"]),
        absensiMasuk: json["absensi_masuk"] == null
            ? null
            : DataAbsenV2.fromJson(json["absensi_masuk"]),
        absensiPulang: json["absensi_pulang"] == null
            ? null
            : DataAbsenV2.fromJson(json["absensi_pulang"]),
        istirahatMulai: json["istirahat_mulai"] == null
            ? null
            : DataAbsenV2.fromJson(json["istirahat_mulai"]),
        istirahatSelesai: json["istirahat_selesai"] == null
            ? null
            : DataAbsenV2.fromJson(json["istirahat_selesai"]),
      );

  Map<String, dynamic> toJson() => {
        "tgl_absensi": tglAbsensi == null ? null : tglAbsensi,
        "hari_absensi": hariAbsensi == null ? null : hariAbsensi,
        "absen_masuk": absenMasuk == null ? null : absenMasuk,
        "absen_pulang": absenPulang == null ? null : absenPulang,
        "terlambat": terlambat == null ? null : terlambat,
        "keterangan": keteranganMasuk == null ? null : keteranganMasuk,
        "ist_mulai": istMulai == null ? null : istMulai,
        "ist_selesai": istSelesai == null ? null : istSelesai,
        "jam_pulang": jamPulang == null ? null : jamPulang!.toIso8601String(),
        "kode_absensi": kodeAbsensi == null
            ? null
            : List<dynamic>.from(kodeAbsensi!.map((x) => x.toJson())),
        "ket_kode": ketKode == null ? null : ketKode,
        "jenis_absensi": jenisAbsensi == null ? null : jenisAbsensi,
        "label_masuk_pulang":
            labelMasukPulang == null ? null : labelMasukPulang,
        "foto_masuk": fotoMasuk == null ? null : fotoMasuk,
        "foto_pulang": fotoPulang == null ? null : fotoPulang,
        "foto_ist_mulai": fotoIstMulai == null ? null : fotoIstMulai,
        "foto_ist_selesai": fotoIstSelesai == null ? null : fotoIstSelesai,
        "nama_karyawan": namaKaryawan == null ? null : namaKaryawan,
        "id_karyawan": idKaryawan == null ? null : idKaryawan,
        "nama_departemen": namaDepartemen == null ? null : namaDepartemen,
        "nama_cabang": namaCabang == null ? null : namaCabang,
        "lat_masuk": latMasuk == null ? null : latMasuk,
        "long_masuk": longMasuk == null ? null : longMasuk,
        "lat_ist_mulai": latIstMulai == null ? null : latIstMulai,
        "long_ist_mulai": longIstMulai == null ? null : longIstMulai,
        "lat_ist_selesai": latIstSelesai == null ? null : latIstSelesai,
        "long_ist_selesai": longIstSelesai == null ? null : longIstSelesai,
        "lat_pulang": latPulang == null ? null : latPulang,
        "long_pulang": longPulang == null ? null : longPulang,
        "jadwal": jadwal == null ? null : jadwal,
        "karyawan": karyawan!.toJson(),
        "jadwal_absensi":
            jadwalAbsensi == null ? null : jadwalAbsensi!.toJson(),
        "absensi_masuk": absensiMasuk == null ? null : absensiMasuk!.toJson(),
        "absensi_pulang":
            absensiPulang == null ? null : absensiPulang!.toJson(),
        "istirahat_mulai":
            istirahatMulai == null ? null : istirahatMulai!.toJson(),
        "istirahat_selesai":
            istirahatSelesai == null ? null : istirahatSelesai!.toJson(),
      };
}

class KodeAbsensi {
  KodeAbsensi({
    this.kodeAbsensi,
    this.ketKodeAbsensi,
  });

  String? kodeAbsensi;
  String? ketKodeAbsensi;

  factory KodeAbsensi.fromJson(Map<String, dynamic> json) => KodeAbsensi(
        kodeAbsensi: json["kode_absensi"] == null ? null : json["kode_absensi"],
        ketKodeAbsensi:
            json["ket_kode_absensi"] == null ? null : json["ket_kode_absensi"],
      );

  Map<String, dynamic> toJson() => {
        "kode_absensi": kodeAbsensi == null ? null : kodeAbsensi,
        "ket_kode_absensi": ketKodeAbsensi == null ? null : ketKodeAbsensi,
      };
}

class Warna {
  Warna({this.color, this.fontColor, this.enableDetail});

  String? color;
  String? fontColor;
  bool? enableDetail;

  factory Warna.fromJson(Map<String, dynamic> json) => Warna(
        color: json["color"] == null ? null : json["color"],
        fontColor: json["font_color"] == null ? null : json["font_color"],
        enableDetail:
            json["enable_detail"] == null ? null : json["enable_detail"],
      );

  Map<String, dynamic> toJson() => {
        "color": color == null ? null : color,
        "font_color": fontColor == null ? null : fontColor,
        "enable_detail": enableDetail == null ? null : enableDetail,
      };
}

RekapAbsensiRespon2 dataRekapAbsensi2FromJson(String str) =>
    RekapAbsensiRespon2.fromJson(json.decode(str));

String dataRekapAbsensi2ToJson(RekapAbsensiRespon2 data) =>
    json.encode(data.toJson());

class RekapAbsensiRespon2 {
  bool? success;
  List<DataRekapAbsensi2>? data;

  RekapAbsensiRespon2({
    this.success,
    this.data,
  });

  factory RekapAbsensiRespon2.fromJson(Map<String, dynamic> json) =>
      RekapAbsensiRespon2(
        success: json["success"],
        data: json["data"] == null
            ? []
            : List<DataRekapAbsensi2>.from(
                json["data"]!.map((x) => DataRekapAbsensi2.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataRekapAbsensi2 {
  String? tglAbsensi;
  String? hariAbsensi;
  String? absenMasuk;
  String? absenPulang;
  List<KodeAbsensi2>? kodeAbsensi;
  String? ketKode;
  String? namaKaryawan;
  Warna2? warna;

  DataRekapAbsensi2({
    this.tglAbsensi,
    this.hariAbsensi,
    this.absenMasuk,
    this.absenPulang,
    this.kodeAbsensi,
    this.ketKode,
    this.namaKaryawan,
    this.warna,
  });

  factory DataRekapAbsensi2.fromJson(Map<String, dynamic> json) =>
      DataRekapAbsensi2(
        tglAbsensi: json["tgl_absensi"],
        hariAbsensi: json["hari_absensi"],
        absenMasuk: json["absen_masuk"],
        absenPulang: json["absen_pulang"],
        kodeAbsensi: json["kode_absensi"] == null
            ? []
            : List<KodeAbsensi2>.from(
                json["kode_absensi"]!.map((x) => KodeAbsensi.fromJson(x))),
        ketKode: json["ket_kode"],
        namaKaryawan: json["nama_karyawan"],
        warna: json["warna"] == null ? null : Warna2.fromJson(json["warna"]),
      );

  Map<String, dynamic> toJson() => {
        "tgl_absensi": tglAbsensi,
        "hari_absensi": hariAbsensi,
        "absen_masuk": absenMasuk,
        "absen_pulang": absenPulang,
        "kode_absensi": kodeAbsensi == null
            ? []
            : List<dynamic>.from(kodeAbsensi!.map((x) => x.toJson())),
        "ket_kode": ketKode,
        "nama_karyawan": namaKaryawan,
        "warna": warna?.toJson(),
      };
}

class KodeAbsensi2 {
  String? kodeAbsensi;
  String? ketKodeAbsensi;

  KodeAbsensi2({
    this.kodeAbsensi,
    this.ketKodeAbsensi,
  });

  factory KodeAbsensi2.fromJson(Map<String, dynamic> json) => KodeAbsensi2(
        kodeAbsensi: json["kode_absensi"],
        ketKodeAbsensi: json["ket_kode_absensi"],
      );

  Map<String, dynamic> toJson() => {
        "kode_absensi": kodeAbsensi,
        "ket_kode_absensi": ketKodeAbsensi,
      };
}

class Warna2 {
  Warna2({this.color, this.fontColor, this.enableDetail});

  String? color;
  String? fontColor;
  bool? enableDetail;

  factory Warna2.fromJson(Map<String, dynamic> json) => Warna2(
        color: json["color"] == null ? null : json["color"],
        fontColor: json["font_color"] == null ? null : json["font_color"],
        enableDetail:
            json["enable_detail"] == null ? null : json["enable_detail"],
      );

  Map<String, dynamic> toJson() => {
        "color": color == null ? null : color,
        "font_color": fontColor == null ? null : fontColor,
        "enable_detail": enableDetail == null ? null : enableDetail,
      };
}

class DataAbsenV2 {
  String? jam;
  String? keterangan;
  String? lokasi;
  String? lat;
  String? long;
  String? foto;

  DataAbsenV2({
    this.jam,
    this.keterangan,
    this.lokasi,
    this.lat,
    this.long,
    this.foto,
  });

  factory DataAbsenV2.fromJson(Map<String, dynamic> json) => DataAbsenV2(
        jam: json["jam"] == null ? null : json["jam"],
        keterangan: json["keterangan"] == null ? null : json["keterangan"],
        lokasi: json["lokasi"] == null ? null : json["lokasi"],
        lat: json["lat"] == null ? null : json["lat"],
        long: json["long"] == null ? null : json["long"],
        foto: json["foto"] == null ? null : json["foto"],
      );

  Map<String, dynamic> toJson() => {
        "jam": jam == null ? null : jam,
        "keterangan": keterangan == null ? null : keterangan,
        "lokasi": lokasi == null ? null : lokasi,
        "lat": lat == null ? null : lat,
        "long": long == null ? null : long,
        "foto": foto == null ? null : foto,
      };
}

class JadwalAbsensiV2 {
  String? jenis;
  String? jamKerja;
  List<KodeAbsensi>? kodeAbsensi;
  String? ketKode;

  JadwalAbsensiV2({
    this.jenis,
    this.jamKerja,
    this.kodeAbsensi,
    this.ketKode,
  });

  factory JadwalAbsensiV2.fromJson(Map<String, dynamic> json) =>
      JadwalAbsensiV2(
          jenis: json["jenis"] == null ? null : json["jenis"],
          jamKerja: json["jam_kerja"] == null ? null : json["jam_kerja"],
          kodeAbsensi: json["kode_absensi"] == null
              ? null
              : List<KodeAbsensi>.from(
                  json["kode_absensi"].map((x) => KodeAbsensi.fromJson(x))),
          ketKode: json["ket_kode"] == null ? null : json["ket_kode"]);

  Map<String, dynamic> toJson() => {
        "jenis": jenis == null ? null : jenis,
        "jam_kerja": jamKerja == null ? null : jamKerja,
        "kode_absensi": kodeAbsensi == null
            ? null
            : List<dynamic>.from(kodeAbsensi!.map((x) => x.toJson())),
        "ket_kode": ketKode == null ? null : ketKode,
      };
}

class KaryawanV2 {
  String? nama;
  String? nik;
  String? jabatan;
  String? cabang;
  String? departemen;

  KaryawanV2({
    this.nama,
    this.nik,
    this.jabatan,
    this.cabang,
    this.departemen,
  });

  factory KaryawanV2.fromJson(Map<String, dynamic> json) => KaryawanV2(
        nama: json["nama"] == null ? null : json["nama"],
        nik: json["nik"] == null ? null : json["nik"],
        jabatan: json["jabatan"] == null ? null : json["jabatan"],
        cabang: json["cabang"] == null ? null : json["cabang"],
        departemen: json["departemen"] == null ? null : json["departemen"],
      );

  Map<String, dynamic> toJson() => {
        "nama": nama == null ? null : nama,
        "nik": nik == null ? null : nik,
        "jabatan": jabatan == null ? null : jabatan,
        "cabang": cabang == null ? null : cabang,
        "departemen": departemen == null ? null : departemen,
      };
}
