import 'dart:convert';

DataLayananRespon dataLayananResponFromJson(String str) => DataLayananRespon.fromJson(json.decode(str));

String dataLayananResponToJson(DataLayananRespon data) => json.encode(data.toJson());

class DataLayananRespon {
  bool? success;
  String? message;
  DataLayanan? dataLayanan;

  DataLayananRespon({this.success, this.message, this.dataLayanan});

  DataLayananRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataLayanan = json['data_layanan'] != null
        ? new DataLayanan.fromJson(json['data_layanan'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataLayanan != null) {
      data['data_layanan'] = this.dataLayanan!.toJson();
    }
    return data;
  }
}

class DataLayanan {
  int? totalLayanan;
  String? totalHarga;
  List<Layanan>? data;

  DataLayanan({this.totalLayanan, this.totalHarga, this.data});

  DataLayanan.fromJson(Map<String, dynamic> json) {
    totalLayanan = json['total_layanan'];
    totalHarga = json['total_harga'];
    if (json['layanan'] != null) {
      data = <Layanan>[];
      json['layanan'].forEach((v) {
        data!.add(new Layanan.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_layanan'] = this.totalLayanan;
    data['total_harga'] = this.totalHarga;
    if (this.data != null) {
      data['layanan'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Layanan {
  String? idPipelineLayanan;
  String? idPipelineMain;
  String? kodeLayanan;
  String? namaLayanan;
  String? idKaryawan;
  String? idProductM;
  String? harga;
  String? jumlah;
  String? diskon;
  String? hargaTotal;
  String? jumlahHarga;
  String? jumlahDiskon;
  String? idCompany;

  Layanan(
      {this.idPipelineLayanan,
        this.idPipelineMain,
        this.kodeLayanan,
        this.namaLayanan,
        this.idKaryawan,
        this.idProductM,
        this.harga,
        this.jumlah,
        this.diskon,
        this.hargaTotal,
        this.jumlahHarga,
        this.jumlahDiskon,
        this.idCompany});

  Layanan.fromJson(Map<String, dynamic> json) {
    idPipelineLayanan = json['id_pipeline_layanan'];
    idPipelineMain = json['id_pipeline_main'];
    kodeLayanan = json['kode_layanan'];
    namaLayanan = json['nama_layanan'];
    idKaryawan = json['id_karyawan'];
    idProductM = json['id_product_m'];
    harga = json['harga'];
    jumlah = json['jumlah'];
    diskon = json['diskon'];
    hargaTotal = json['harga_total'];
    jumlahHarga = json['jumlah_harga'];
    jumlahDiskon = json['jumlah_diskon'];
    idCompany = json['id_company'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pipeline_layanan'] = this.idPipelineLayanan;
    data['id_pipeline_main'] = this.idPipelineMain;
    data['kode_layanan'] = this.kodeLayanan;
    data['nama_layanan'] = this.namaLayanan;
    data['id_karyawan'] = this.idKaryawan;
    data['id_product_m'] = this.idProductM;
    data['harga'] = this.harga;
    data['jumlah'] = this.jumlah;
    data['diskon'] = this.diskon;
    data['harga_total'] = this.hargaTotal;
    data['jumlah_harga'] = this.jumlahHarga;
    data['jumlah_diskon'] = this.jumlahDiskon;
    data['id_company'] = this.idCompany;
    return data;
  }
}

