import 'dart:convert';

import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';

DataKanbanRespon dataKanbanResponFromJson(String str) => DataKanbanRespon.fromJson(json.decode(str));

String dataKanbanResponToJson(DataKanbanRespon data) => json.encode(data.toJson());

class DataKanbanRespon {
  bool? success;
  String? message;
  List<DataKanban>? dataKanban;

  DataKanbanRespon({this.success, this.message, this.dataKanban});

  DataKanbanRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_kanban'] != null) {
      dataKanban = <DataKanban>[];
      json['data_kanban'].forEach((v) {
        dataKanban!.add(new DataKanban.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataKanban != null) {
      data['data_kanban'] = this.dataKanban!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataKanban {
  String? idPipelineMain;
  String? idPelanggan;
  String? namaPerusahaan;
  String? picNama;
  String? namaLengkapSales;
  String? picTelp;
  String? tglInput;
  // String? totalHarga;
  // String? layanan;
  String? idPipelineMainLog;
  StatusPengajuan? statusPengajuan;
  Button? button;
  List<Layanan>? layanan;
  String? tglPengajuan;
  String? idTahapanM;
  String? jenisTahapan;
  String? tahapanSebelumId;
  String? tahapanSebelumNm;
  bool? refresh;

  DataKanban(
      {this.idPipelineMain,
        this.idPelanggan,
        this.namaPerusahaan,
        this.picNama,
        this.namaLengkapSales,
        this.picTelp,
        this.tglInput,
        // this.totalHarga,
        // this.layanan,
        this.idPipelineMainLog,
        this.statusPengajuan,
        this.button,
        this.layanan,
        this.tglPengajuan,
        this.idTahapanM,
        this.jenisTahapan,
        this.tahapanSebelumId,
        this.tahapanSebelumNm,
        this.refresh = false});

  DataKanban.fromJson(Map<String, dynamic> json) {
    idPipelineMain = json['id_pipeline_main'];
    idPelanggan = json['id_pelanggan'];
    namaPerusahaan = json['nama_perusahaan'];
    picNama = json['pic_nama'];
    namaLengkapSales = json['nama_lengkap'];
    picTelp = json['pic_telp'];
    tglInput = json['tgl_input'];
    // totalHarga = json['total_harga'];
    // layanan = json['layanan'];
    idPipelineMainLog = json['id_pipeline_main_log'];
    statusPengajuan = json['status_pengajuan'] != null
        ? new StatusPengajuan.fromJson(json['status_pengajuan'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    if (json['layanan'] != null) {
      layanan = <Layanan>[];
      json['layanan'].forEach((v) {
        layanan!.add(new Layanan.fromJson(v));
      });
    }
    tglPengajuan = json['tgl_pengajuan'];
    idTahapanM = json['id_tahapan_m'];
    jenisTahapan = json['jenis_tahapan'];
    tahapanSebelumId = json['tahapan_sebelum_id'];
    tahapanSebelumNm = json['tahapan_sebelum_nm'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pipeline_main'] = this.idPipelineMain;
    data['id_pelanggan'] = this.idPelanggan;
    data['nama_perusahaan'] = this.namaPerusahaan;
    data['pic_nama'] = this.picNama;
    data['nama_lengkap'] = this.namaLengkapSales;
    data['pic_telp'] = this.picTelp;
    data['tgl_input'] = this.tglInput;
    // data['total_harga'] = this.totalHarga;
    // data['layanan'] = this.layanan;
    data['id_pipeline_main_log'] = this.idPipelineMainLog;
    if (this.statusPengajuan != null) {
      data['status_pengajuan'] = this.statusPengajuan!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.layanan != null) {
      data['layanan'] = this.layanan!.map((v) => v.toJson()).toList();
    }
    data['tgl_pengajuan'] = this.tglPengajuan;
    data['id_tahapan_m'] = this.idTahapanM;
    data['jenis_tahapan'] = this.jenisTahapan;
    data['tahapan_sebelum_id'] = this.tahapanSebelumId;
    data['tahapan_sebelum_nm'] = this.tahapanSebelumNm;
    return data;
  }
}

// class DataLayanan {
//   String? idPipelineLayanan;
//   String? idPipelineMain;
//   String? idProductM;
//   String? kode;
//   String? namaLayanan;
//   String? harga;
//   String? jumlah;
//   String? diskon;
//   String? hargaTotal;
//   String? idCompany;
//
//   DataLayanan(
//       {this.idPipelineLayanan,
//         this.idPipelineMain,
//         this.idProductM,
//         this.kode,
//         this.namaLayanan,
//         this.harga,
//         this.jumlah,
//         this.diskon,
//         this.hargaTotal,
//         this.idCompany});
//
//   DataLayanan.fromJson(Map<String, dynamic> json) {
//     idPipelineLayanan = json['id_pipeline_layanan'];
//     idPipelineMain = json['id_pipeline_main'];
//     idProductM = json['id_product_m'];
//     kode = json['kode_layanan'];
//     namaLayanan = json['nama_layanan'];
//     harga = json['harga'];
//     jumlah = json['jumlah'];
//     diskon = json['diskon'];
//     hargaTotal = json['harga_total'];
//     idCompany = json['id_company'];
//   }
//
//   Map<String, dynamic> toJson() {
//     final Map<String, dynamic> data = new Map<String, dynamic>();
//     data['id_pipeline_layanan'] = this.idPipelineLayanan;
//     data['id_pipeline_main'] = this.idPipelineMain;
//     data['id_product_m'] = this.idProductM;
//     data['kode_layanan'] = this.kode;
//     data['nama_layanan'] = this.namaLayanan;
//     data['harga'] = this.harga;
//     data['jumlah'] = this.jumlah;
//     data['diskon'] = this.diskon;
//     data['harga_total'] = this.hargaTotal;
//     data['id_company'] = this.idCompany;
//     return data;
//   }
// }

class StatusPengajuan {
  String? status;
  String? value;
  String? color;
  String? fontColor;
  String? labelColor;
  String? labelFontColor;

  StatusPengajuan({this.status, this.value, this.color, this.fontColor, this.labelColor, this.labelFontColor});

  StatusPengajuan.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    value = json['value'];
    color = json['color'];
    fontColor = json['font_color'];
    labelColor = json['label_color'];
    labelFontColor = json['label_font_color'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['status'] = this.status;
    data['value'] = this.value;
    data['color'] = this.color;
    data['font_color'] = this.fontColor;
    data['label_color'] = this.labelColor;
    data['label_font_color'] = this.labelFontColor;
    return data;
  }
}

class Button {
  bool? buttonDetail;
  bool? buttonUbahTahapan;
  bool? buttonBatalkan;
  bool? buttonHapus;
  bool? buttonAktivitas;
  bool? buttonPindahBulan;
  bool? buttonLayanan;
  bool? buttonApprove;
  bool? buttonTolak;

  Button(
      {this.buttonDetail,
        this.buttonUbahTahapan,
        this.buttonBatalkan,
        this.buttonHapus,
        this.buttonAktivitas,
        this.buttonPindahBulan,
        this.buttonLayanan,
        this.buttonApprove,
        this.buttonTolak});

  Button.fromJson(Map<String, dynamic> json) {
    buttonDetail = json['button_detail'];
    buttonUbahTahapan = json['button_ubah_tahapan'];
    buttonBatalkan = json['button_batalkan'];
    buttonHapus = json['button_hapus'];
    buttonAktivitas = json['button_aktivitas'];
    buttonPindahBulan = json['button_pindah_bulan'];
    buttonLayanan = json['button_layanan'];
    buttonApprove = json['button_approve'];
    buttonTolak = json['button_tolak'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['button_detail'] = this.buttonDetail;
    data['button_ubah_tahapan'] = this.buttonUbahTahapan;
    data['button_batalkan'] = this.buttonBatalkan;
    data['button_hapus'] = this.buttonHapus;
    data['button_aktivitas'] = this.buttonAktivitas;
    data['button_pindah_bulan'] = this.buttonPindahBulan;
    data['button_layanan'] = this.buttonLayanan;
    data['button_approve'] = this.buttonApprove;
    data['button_tolak'] = this.buttonTolak;
    return data;
  }
}

