import 'dart:convert';

PageUbahPasswordModel pageUbahPasswordModelFromJson(String str) => PageUbahPasswordModel.fromJson(json.decode(str));

String pageUbahPasswordModelToJson(PageUbahPasswordModel data) => json.encode(data.toJson());

class PageUbahPasswordModel {
  MenuUbahPassword? menuUbahPassword;

  PageUbahPasswordModel({this.menuUbahPassword});

  PageUbahPasswordModel.fromJson(Map<String, dynamic> json) {
    menuUbahPassword = json['menu_ubah_password'] != null
        ? new MenuUbahPassword.fromJson(json['menu_ubah_password'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuUbahPassword != null) {
      data['menu_ubah_password'] = this.menuUbahPassword!.toJson();
    }
    return data;
  }
}

class MenuUbahPassword {
  String? title;
  Data? data;
  Button? button;
  Message? message;
  String? locale;

  MenuUbahPassword({this.title, this.data, this.button, this.message, this.locale});

  MenuUbahPassword.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class Data {
  String? passwordLama;
  String? passwordBaru;
  String? konfirmasiPasswordBaru;
  String? minimalKarakter;

  Data(
      {this.passwordLama,
        this.passwordBaru,
        this.konfirmasiPasswordBaru,
        this.minimalKarakter});

  Data.fromJson(Map<String, dynamic> json) {
    passwordLama = json['password_lama'];
    passwordBaru = json['password_baru'];
    konfirmasiPasswordBaru = json['konfirmasi_password_baru'];
    minimalKarakter = json['minimal_karakter'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['password_lama'] = this.passwordLama;
    data['password_baru'] = this.passwordBaru;
    data['konfirmasi_password_baru'] = this.konfirmasiPasswordBaru;
    data['minimal_karakter'] = this.minimalKarakter;
    return data;
  }
}

class Button {
  String? btnUbahPassword;

  Button({this.btnUbahPassword});

  Button.fromJson(Map<String, dynamic> json) {
    btnUbahPassword = json['btn_ubah_password'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_ubah_password'] = this.btnUbahPassword;
    return data;
  }
}

class Message {
  String? passwordBeda;
  String? passwordEmpty;

  Message({this.passwordBeda, this.passwordEmpty});

  Message.fromJson(Map<String, dynamic> json) {
    passwordBeda = json['password_beda'];
    passwordEmpty = json['password_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['password_beda'] = this.passwordBeda;
    data['password_empty'] = this.passwordEmpty;
    return data;
  }
}
