import 'dart:convert';

PageSosModel pageSosModelFromJson(String str) =>
    PageSosModel.fromJson(json.decode(str));

String pageSosModelToJson(PageSosModel data) => json.encode(data.toJson());

class PageSosModel {
  MenuSos? menuSos;

  PageSosModel({this.menuSos});

  PageSosModel.fromJson(Map<String, dynamic> json) {
    menuSos = json['menu_sos'] != null
        ? new MenuSos.fromJson(json['menu_sos'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuSos != null) {
      data['menu_sos'] = this.menuSos!.toJson();
    }
    return data;
  }
}

class MenuSos {
  Title? title;
  Data? data;
  PesanKonfirmasi? pesanKonfirmasi;
  Button? button;
  MenuSos({this.title, this.data, this.pesanKonfirmasi, this.button});

  MenuSos.fromJson(Map<String, dynamic> json) {
    title = json['title'] != null ? new Title.fromJson(json['title']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    pesanKonfirmasi = json['pesan_konfirmasi'] != null
        ? new PesanKonfirmasi.fromJson(json['pesan_konfirmasi'])
        : null;
    button = json['button'] != null
        ? new Button.fromJson(json['button'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.title != null) {
      data['title'] = this.title!.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.pesanKonfirmasi != null) {
      data['pesan_konfirmasi'] = this.pesanKonfirmasi!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }

    return data;
  }
}

class Data {
  String? keterangan;
  String? oleh;
  String? tanggal;
  String? lokasi;
  String? akurasi;

  Data({this.keterangan, this.oleh, this.tanggal});

  Data.fromJson(Map<String, dynamic> json) {
    keterangan = json['keterangan'];
    oleh = json['oleh'];
    tanggal = json['tanggal'];
    lokasi = json['lokasi'];
    akurasi = json['akurasi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['keterangan'] = this.keterangan;
    data['oleh'] = this.oleh;
    data['tanggal'] = this.tanggal;
    data['lokasi'] = this.lokasi;
    data['akurasi'] = this.akurasi;
    return data;
  }
}

class Button {
  String? btnPatroli;
  String? btnSubmit;
  String? btnCancle;

  Button({this.btnPatroli, this.btnSubmit, this.btnCancle});

  Button.fromJson(Map<String, dynamic> json) {
    btnPatroli = json['btnPatroli'];
    btnSubmit = json['btnSubmit'];
    btnCancle = json['btnCancle'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btnPatroli'] = this.btnPatroli;
    data['btnSubmit'] = this.btnSubmit;
    data['btnCancle'] = this.btnCancle;
    return data;
  }
}

class Title {
  String? parentTitle;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  Title({
    this.parentTitle,
    this.titleDetail,
    this.titleRekap,
    this.tabSaya,
    this.tabKaryawan,
  });

  Title.fromJson(Map<String, dynamic> json) {
    parentTitle = json['parent_title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['parent_title'] = this.parentTitle;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    return data;
  }
}

class PesanKonfirmasi {
  String? tolak;
  String? tolakSemua;
  String? setujui;
  String? setujuiSemua;
  String? batalkan;
  String? jenisIsEmpty;
  String? tanggalIsEmpty;
  String? fileIsEmpty;
  String? ketIsEmpty;
  String? tidakAdaLampiran;

  PesanKonfirmasi(
      {this.tolak,
      this.tolakSemua,
      this.setujui,
      this.setujuiSemua,
      this.batalkan,
      this.jenisIsEmpty,
      this.tanggalIsEmpty,
      this.fileIsEmpty,
      this.ketIsEmpty,
      this.tidakAdaLampiran});

  PesanKonfirmasi.fromJson(Map<String, dynamic> json) {
    tolak = json['tolak'];
    tolakSemua = json['tolak_semua'];
    setujui = json['setujui'];
    setujuiSemua = json['setujui_semua'];
    batalkan = json['batalkan'];
    jenisIsEmpty = json['jenis_is_empty'];
    tanggalIsEmpty = json['tanggal_is_empty'];
    fileIsEmpty = json['file_is_empty'];
    ketIsEmpty = json['ket_is_empty'];
    tidakAdaLampiran = json['tidak_ada_lampiran'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tolak'] = this.tolak;
    data['tolak_semua'] = this.tolakSemua;
    data['setujui'] = this.setujui;
    data['setujui_semua'] = this.setujuiSemua;
    data['batalkan'] = this.batalkan;
    data['jenis_is_empty'] = this.jenisIsEmpty;
    data['tanggal_is_empty'] = this.tanggalIsEmpty;
    data['file_is_empty'] = this.fileIsEmpty;
    data['ket_is_empty'] = this.ketIsEmpty;
    data['tidak_ada_lampiran'] = this.tidakAdaLampiran;
    return data;
  }
}
