import 'dart:convert';

PageRekapModel pageRekapModelFromJson(String str) => PageRekapModel.fromJson(json.decode(str));

String pageRekapModelToJson(PageRekapModel data) => json.encode(data.toJson());

class PageRekapModel {
  MenuRekap? menuRekap;

  PageRekapModel({this.menuRekap});

  PageRekapModel.fromJson(Map<String, dynamic> json) {
    menuRekap = json['menu_rekap'] != null
        ? new MenuRekap.fromJson(json['menu_rekap'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuRekap != null) {
      data['menu_rekap'] = this.menuRekap!.toJson();
    }
    return data;
  }
}

class MenuRekap {
  String? title;
  RekapAbsensi? rekapAbsensi;
  Menu? menu;

  MenuRekap({this.title, this.rekapAbsensi, this.menu});

  MenuRekap.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    rekapAbsensi = json['rekap_absensi'] != null
        ? new RekapAbsensi.fromJson(json['rekap_absensi'])
        : null;
    menu = json['menu'] != null ? new Menu.fromJson(json['menu']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.rekapAbsensi != null) {
      data['rekap_absensi'] = this.rekapAbsensi!.toJson();
    }
    if (this.menu != null) {
      data['menu'] = this.menu!.toJson();
    }
    return data;
  }
}

class RekapAbsensi {
  String? header;
  Data? data;

  RekapAbsensi({this.header, this.data});

  RekapAbsensi.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  String? hadir;
  String? alpa;
  String? sakit;
  String? izin;
  String? cuti;
  String? lembur;
  String? terlambat;
  String? pulangCepat;
  String? tidakAbsenPulang;
  String? kali;
  String? menit;
  String? hari;

  Data(
      {this.hadir,
        this.alpa,
        this.sakit,
        this.izin,
        this.cuti,
        this.lembur,
        this.terlambat,
        this.pulangCepat,
        this.tidakAbsenPulang,
        this.kali,
        this.menit,
        this.hari});

  Data.fromJson(Map<String, dynamic> json) {
    hadir = json['hadir'];
    alpa = json['alpa'];
    sakit = json['sakit'];
    izin = json['izin'];
    cuti = json['cuti'];
    lembur = json['lembur'];
    terlambat = json['terlambat'];
    pulangCepat = json['pulang_cepat'];
    tidakAbsenPulang = json['tidak_absen_pulang'];
    kali = json['kali'];
    menit = json['menit'];
    hari = json['hari'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hadir'] = this.hadir;
    data['alpa'] = this.alpa;
    data['sakit'] = this.sakit;
    data['izin'] = this.izin;
    data['cuti'] = this.cuti;
    data['lembur'] = this.lembur;
    data['terlambat'] = this.terlambat;
    data['pulang_cepat'] = this.pulangCepat;
    data['tidak_absen_pulang'] = this.tidakAbsenPulang;
    data['kali'] = this.kali;
    data['menit'] = this.menit;
    data['hari'] = this.hari;
    return data;
  }
}

class Menu {
  DataAbsen? dataAbsen;
  DataAbsen? rekapAbsen;
  DataAbsen? dataIzin;
  DataAbsen? dataLembur;

  Menu({this.dataAbsen, this.rekapAbsen, this.dataIzin, this.dataLembur});

  Menu.fromJson(Map<String, dynamic> json) {
    dataAbsen = json['data_absen'] != null
        ? new DataAbsen.fromJson(json['data_absen'])
        : null;
    rekapAbsen = json['rekap_absen'] != null
        ? new DataAbsen.fromJson(json['rekap_absen'])
        : null;
    dataIzin = json['data_izin'] != null
        ? new DataAbsen.fromJson(json['data_izin'])
        : null;
    dataLembur = json['data_lembur'] != null
        ? new DataAbsen.fromJson(json['data_lembur'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.dataAbsen != null) {
      data['data_absen'] = this.dataAbsen!.toJson();
    }
    if (this.rekapAbsen != null) {
      data['rekap_absen'] = this.rekapAbsen!.toJson();
    }
    if (this.dataIzin != null) {
      data['data_izin'] = this.dataIzin!.toJson();
    }
    if (this.dataLembur != null) {
      data['data_lembur'] = this.dataLembur!.toJson();
    }
    return data;
  }
}

class DataAbsen {
  String? title;
  String? subtitle;

  DataAbsen({this.title, this.subtitle});

  DataAbsen.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    return data;
  }
}
