import 'dart:convert';

PageRangkumanAbsensiModel pageRangkumanAbsensiModelFromJson(String str) => PageRangkumanAbsensiModel.fromJson(json.decode(str));

String pageRangkumanAbsensiModelToJson(PageRangkumanAbsensiModel data) => json.encode(data.toJson());

class PageRangkumanAbsensiModel {
  MenuRangkumanAbsensi? menuRangkumanAbsensi;

  PageRangkumanAbsensiModel({this.menuRangkumanAbsensi});

  PageRangkumanAbsensiModel.fromJson(Map<String, dynamic> json) {
    menuRangkumanAbsensi = json['menu_rangkuman_absensi'] != null
        ? new MenuRangkumanAbsensi.fromJson(json['menu_rangkuman_absensi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuRangkumanAbsensi != null) {
      data['menu_rangkuman_absensi'] = this.menuRangkumanAbsensi!.toJson();
    }
    return data;
  }
}

class MenuRangkumanAbsensi {
  String? title;
  String? message;
  Data? data;

  MenuRangkumanAbsensi({this.title, this.message, this.data});

  MenuRangkumanAbsensi.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    message = json['message'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  String? hadir;
  String? alpa;
  String? sakit;
  String? izin;
  String? cuti;
  String? lembur;
  String? terlambat;
  String? pulangCepat;
  String? tidakAbsenPulang;
  String? kali;
  String? menit;
  String? hari;

  Data(
      {this.hadir,
        this.alpa,
        this.sakit,
        this.izin,
        this.cuti,
        this.lembur,
        this.terlambat,
        this.pulangCepat,
        this.tidakAbsenPulang,
        this.kali,
        this.menit,
        this.hari});

  Data.fromJson(Map<String, dynamic> json) {
    hadir = json['hadir'];
    alpa = json['alpa'];
    sakit = json['sakit'];
    izin = json['izin'];
    cuti = json['cuti'];
    lembur = json['lembur'];
    terlambat = json['terlambat'];
    pulangCepat = json['pulang_cepat'];
    tidakAbsenPulang = json['tidak_absen_pulang'];
    kali = json['kali'];
    menit = json['menit'];
    hari = json['hari'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hadir'] = this.hadir;
    data['alpa'] = this.alpa;
    data['sakit'] = this.sakit;
    data['izin'] = this.izin;
    data['cuti'] = this.cuti;
    data['lembur'] = this.lembur;
    data['terlambat'] = this.terlambat;
    data['pulang_cepat'] = this.pulangCepat;
    data['tidak_absen_pulang'] = this.tidakAbsenPulang;
    data['kali'] = this.kali;
    data['menit'] = this.menit;
    data['hari'] = this.hari;
    return data;
  }
}
