import 'dart:convert';

PagePatroliModel pagePatroliModelFromJson(String str) =>
    PagePatroliModel.fromJson(json.decode(str));

String pagePatroliModelToJson(PagePatroliModel data) =>
    json.encode(data.toJson());

class PagePatroliModel {
  MenuPatroli? menuPatroli;

  PagePatroliModel({this.menuPatroli});

  PagePatroliModel.fromJson(Map<String, dynamic> json) {
    menuPatroli = json['menu_patroli'] != null
        ? new MenuPatroli.fromJson(json['menu_patroli'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuPatroli != null) {
      data['menu_patroli'] = this.menuPatroli!.toJson();
    }
    return data;
  }
}

class MenuPatroli {
  Title? title;
  Data? data;
  QR? qr;

  MenuPatroli({this.title, this.data, this.qr});

  MenuPatroli.fromJson(Map<String, dynamic> json) {
    title = json['title'] != null ? new Title.fromJson(json['title']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    qr = json['qr'] != null ? new QR.fromJson(json['qr']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.title != null) {
      data['title'] = this.title!.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.qr != null) {
      data['qr'] = this.qr!.toJson();
    }
    return data;
  }
}

class Data {
  String? jabatan;
  String? cabang;
  String? departemen;
  String? namaKaryawan;
  String? pilihJadwal;
  String? peringatanWaktu;
  String? patroli;
  String? lokasi;
  String? area;
  String? jam;
  String? keterangan;
  Data({
    this.jabatan,
    this.cabang,
    this.departemen,
    this.namaKaryawan,
    this.pilihJadwal,
    this.peringatanWaktu,
    this.patroli,
    this.lokasi,
    this.area,
    this.jam,
    this.keterangan,
  });

  Data.fromJson(Map<String, dynamic> json) {
    jabatan = json['jabatan'];
    cabang = json['cabang'];
    departemen = json['departemen'];
    namaKaryawan = json['nama_karyawan'];
    pilihJadwal = json['pilih_jadwal'];
    peringatanWaktu = json['peringatan_waktu'];
    patroli = json['patroli'];
    lokasi = json['lokasi'];
    area = json['area'];
    jam = json['jam'];
    keterangan = json['keterangan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['jabatan'] = this.jabatan;
    data['cabang'] = this.cabang;
    data['departemen'] = this.departemen;
    data['nama_karyawan'] = this.namaKaryawan;
    data['pilih_jadwal'] = this.pilihJadwal;
    data['peringatan_waktu'] = this.peringatanWaktu;
    data['patroli'] = this.patroli;
    data['lokasi'] = this.lokasi;
    data['area'] = this.area;
    data['jam'] = this.jam;
    data['keterangan'] = this.keterangan;
    return data;
  }
}

class Title {
  String? parentTitle;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  String? titlePatroli;
  Title(
      {this.parentTitle,
      this.titleDetail,
      this.titleRekap,
      this.tabSaya,
      this.tabKaryawan,
      this.titlePatroli});

  Title.fromJson(Map<String, dynamic> json) {
    parentTitle = json['parent_title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    titlePatroli = json['title_patroli'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['parent_title'] = this.parentTitle;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    data['title_patroli'] = this.titlePatroli;
    return data;
  }
}

class QR {
  String? description;

  QR({this.description});

  QR.fromJson(Map<String, dynamic> json) {
    description = json['description'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> qr = new Map<String, dynamic>();
    qr['description'] = this.description;
    return qr;
  }
}
