import 'dart:convert';

MessagePageModel pageMessageModelFromJson(String str) => MessagePageModel.fromJson(json.decode(str));

String pageMessageModelToJson(MessagePageModel data) => json.encode(data.toJson());

class MessagePageModel {
  Message? message;

  MessagePageModel({this.message});

  MessagePageModel.fromJson(Map<String, dynamic> json) {
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class Message {
  String? gpsBelumDisetujui;
  String? gpsBelumDinyalakan;
  String? terdeteksiMock;
  String? gpsBelumSiap;
  String? developerMode;

  Message(
      {this.gpsBelumDisetujui,
        this.gpsBelumDinyalakan,
        this.terdeteksiMock,
        this.gpsBelumSiap,
        this.developerMode});

  Message.fromJson(Map<String, dynamic> json) {
    gpsBelumDisetujui = json['gps_belum_disetujui'];
    gpsBelumDinyalakan = json['gps_belum_dinyalakan'];
    terdeteksiMock = json['terdeteksi_mock'];
    gpsBelumSiap = json['gps_belum_siap'];
    developerMode = json['developer_mode'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['gps_belum_disetujui'] = this.gpsBelumDisetujui;
    data['gps_belum_dinyalakan'] = this.gpsBelumDinyalakan;
    data['terdeteksi_mock'] = this.terdeteksiMock;
    data['gps_belum_siap'] = this.gpsBelumSiap;
    data['developer_mode'] = this.developerMode;
    return data;
  }
}
