import 'dart:convert';

PageInfoGajiModel pageInfoGajiModelFromJson(String str) => PageInfoGajiModel.fromJson(json.decode(str));

String pageInfoGajiModelToJson(PageInfoGajiModel data) => json.encode(data.toJson());

class PageInfoGajiModel {
  MenuInfoGaji? menuInfoGaji;

  PageInfoGajiModel({this.menuInfoGaji});

  PageInfoGajiModel.fromJson(Map<String, dynamic> json) {
    menuInfoGaji = json['menu_info_gaji'] != null
        ? new MenuInfoGaji.fromJson(json['menu_info_gaji'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuInfoGaji != null) {
      data['menu_info_gaji'] = this.menuInfoGaji!.toJson();
    }
    return data;
  }
}

class MenuInfoGaji {
  String? title;
  DialogPassword? dialogPassword;
  Penerimaan? penerimaan;
  Potongan? potongan;
  TunjDibiayaiPerusahaan? tunjDibiayaiPerusahaan;
  GajiDiterima? gajiDiterima;

  MenuInfoGaji(
      {this.title,
        this.dialogPassword,
        this.penerimaan,
        this.potongan,
        this.tunjDibiayaiPerusahaan,
        this.gajiDiterima});

  MenuInfoGaji.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    dialogPassword = json['dialog_password'] != null
        ? new DialogPassword.fromJson(json['dialog_password'])
        : null;
    penerimaan = json['penerimaan'] != null
        ? new Penerimaan.fromJson(json['penerimaan'])
        : null;
    potongan = json['potongan'] != null
        ? new Potongan.fromJson(json['potongan'])
        : null;
    tunjDibiayaiPerusahaan = json['tunj_dibiayai_perusahaan'] != null
        ? new TunjDibiayaiPerusahaan.fromJson(json['tunj_dibiayai_perusahaan'])
        : null;
    gajiDiterima = json['gaji_diterima'] != null
        ? new GajiDiterima.fromJson(json['gaji_diterima'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.dialogPassword != null) {
      data['dialog_password'] = this.dialogPassword!.toJson();
    }
    if (this.penerimaan != null) {
      data['penerimaan'] = this.penerimaan!.toJson();
    }
    if (this.potongan != null) {
      data['potongan'] = this.potongan!.toJson();
    }
    if (this.tunjDibiayaiPerusahaan != null) {
      data['tunj_dibiayai_perusahaan'] = this.tunjDibiayaiPerusahaan!.toJson();
    }
    if (this.gajiDiterima != null) {
      data['gaji_diterima'] = this.gajiDiterima!.toJson();
    }
    return data;
  }
}

class DialogPassword {
  String? password;
  String? btnClose;
  String? btnSubmit;

  DialogPassword({this.password, this.btnClose, this.btnSubmit});

  DialogPassword.fromJson(Map<String, dynamic> json) {
    password = json['password'];
    btnClose = json['btn_close'];
    btnSubmit = json['btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['password'] = this.password;
    data['btn_close'] = this.btnClose;
    data['btn_submit'] = this.btnSubmit;
    return data;
  }
}

class Penerimaan {
  String? header;
  String? gajiPokok;
  String? uangMakan;
  String? uangKomisi;
  String? uangLembur;
  String? tunjJabatan;
  String? tunjTransport;
  String? tunjIstri;
  String? tunjAnak;
  String? penerimaanLain;
  String? ttlPenerimaan;

  Penerimaan(
      {this.header,
        this.gajiPokok,
        this.uangMakan,
        this.uangKomisi,
        this.uangLembur,
        this.tunjJabatan,
        this.tunjTransport,
        this.tunjIstri,
        this.tunjAnak,
        this.penerimaanLain,
        this.ttlPenerimaan});

  Penerimaan.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    gajiPokok = json['gaji_pokok'];
    uangMakan = json['uang_makan'];
    uangKomisi = json['uang_komisi'];
    uangLembur = json['uang_lembur'];
    tunjJabatan = json['tunj_jabatan'];
    tunjTransport = json['tunj_transport'];
    tunjIstri = json['tunj_istri'];
    tunjAnak = json['tunj_anak'];
    penerimaanLain = json['penerimaan_lain'];
    ttlPenerimaan = json['ttl_penerimaan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['gaji_pokok'] = this.gajiPokok;
    data['uang_makan'] = this.uangMakan;
    data['uang_komisi'] = this.uangKomisi;
    data['uang_lembur'] = this.uangLembur;
    data['tunj_jabatan'] = this.tunjJabatan;
    data['tunj_transport'] = this.tunjTransport;
    data['tunj_istri'] = this.tunjIstri;
    data['tunj_anak'] = this.tunjAnak;
    data['penerimaan_lain'] = this.penerimaanLain;
    data['ttl_penerimaan'] = this.ttlPenerimaan;
    return data;
  }
}

class Potongan {
  String? header;
  String? potAbsen;
  String? potTerlambat;
  String? potKoperasi;
  String? potBpjsKes;
  String? potBpjsTk;
  String? potAsuransiKes;
  String? potLain;
  String? ttlPotongan;

  Potongan(
      {this.header,
        this.potAbsen,
        this.potTerlambat,
        this.potKoperasi,
        this.potBpjsKes,
        this.potBpjsTk,
        this.potAsuransiKes,
        this.potLain,
        this.ttlPotongan});

  Potongan.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    potAbsen = json['pot_absen'];
    potTerlambat = json['pot_terlambat'];
    potKoperasi = json['pot_koperasi'];
    potBpjsKes = json['pot_bpjs_kes'];
    potBpjsTk = json['pot_bpjs_tk'];
    potAsuransiKes = json['pot_asuransi_kes'];
    potLain = json['pot_lain'];
    ttlPotongan = json['ttl_potongan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['pot_absen'] = this.potAbsen;
    data['pot_terlambat'] = this.potTerlambat;
    data['pot_koperasi'] = this.potKoperasi;
    data['pot_bpjs_kes'] = this.potBpjsKes;
    data['pot_bpjs_tk'] = this.potBpjsTk;
    data['pot_asuransi_kes'] = this.potAsuransiKes;
    data['pot_lain'] = this.potLain;
    data['ttl_potongan'] = this.ttlPotongan;
    return data;
  }
}

class TunjDibiayaiPerusahaan {
  String? header;
  String? tunjBpjsKes;
  String? tunjBpjsTk;
  String? tunjLain;
  String? ttlTunjBiayaPerusahaan;

  TunjDibiayaiPerusahaan(
      {this.header,
        this.tunjBpjsKes,
        this.tunjBpjsTk,
        this.tunjLain,
        this.ttlTunjBiayaPerusahaan});

  TunjDibiayaiPerusahaan.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    tunjBpjsKes = json['tunj_bpjs_kes'];
    tunjBpjsTk = json['tunj_bpjs_tk'];
    tunjLain = json['tunj_lain'];
    ttlTunjBiayaPerusahaan = json['ttl_tunj_biaya_perusahaan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['tunj_bpjs_kes'] = this.tunjBpjsKes;
    data['tunj_bpjs_tk'] = this.tunjBpjsTk;
    data['tunj_lain'] = this.tunjLain;
    data['ttl_tunj_biaya_perusahaan'] = this.ttlTunjBiayaPerusahaan;
    return data;
  }
}

class GajiDiterima {
  String? header;

  GajiDiterima({this.header});

  GajiDiterima.fromJson(Map<String, dynamic> json) {
    header = json['header'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    return data;
  }
}
