import 'dart:convert';

PageKontakPegawaiModel pageKontakPegawaiModelFromJson(String str) =>
    PageKontakPegawaiModel.fromJson(json.decode(str));

String pageKontakPegawaiModelToJson(PageKontakPegawaiModel data) =>
    json.encode(data.toJson());

class PageKontakPegawaiModel {
  MenuDataKontakPegawai? menuDataKontakPegawai;

  PageKontakPegawaiModel({this.menuDataKontakPegawai});

  PageKontakPegawaiModel.fromJson(Map<String, dynamic> json) {
    menuDataKontakPegawai = json['menu_data_kontak_pegawai'] != null
        ? new MenuDataKontakPegawai.fromJson(json['menu_data_kontak_pegawai'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataKontakPegawai != null) {
      data['menu_data_kontak_pegawai'] = this.menuDataKontakPegawai!.toJson();
    }
    return data;
  }
}

class MenuDataKontakPegawai {
  String? title;
  String? detailTitle;
  Data? data;
  String? locale;

  MenuDataKontakPegawai({this.title, this.detailTitle, this.data});

  MenuDataKontakPegawai.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    detailTitle = json['detail_title'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    locale = json['locale'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['detail_title'] = this.detailTitle;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    data['locale'] = this.locale;
    return data;
  }
}

class Data {
  String? hint_search;
  String? no_telepon;
  String? email;
  String? copyMessage;
  String? copyMessageNomor;

  Data({this.hint_search, this.no_telepon, this.email,this.copyMessage});

  Data.fromJson(Map<String, dynamic> json) {
    hint_search = json['hint_search'];
    no_telepon = json['no_telepon'];
    email = json['email'];
    copyMessage = json['copyMessage'];
    copyMessageNomor = json['copyMessageNomor'];

  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hint_search'] = this.hint_search;
    data['no_telepon'] = this.no_telepon;
    data['email'] = this.email;
    data['copyMessage'] = this.copyMessage;
    data['copyMessageNomor']=this.copyMessageNomor;

    return data;
  }
}
