import 'dart:convert';

PageDataDiriModel pageDataDiriModelFromJson(String str) => PageDataDiriModel.fromJson(json.decode(str));

String pageDataDiriModelToJson(PageDataDiriModel data) => json.encode(data.toJson());

class PageDataDiriModel {
  MenuDataDiri? menuDataDiri;

  PageDataDiriModel({this.menuDataDiri});

  PageDataDiriModel.fromJson(Map<String, dynamic> json) {
    menuDataDiri = json['menu_data_diri'] != null
        ? new MenuDataDiri.fromJson(json['menu_data_diri'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataDiri != null) {
      data['menu_data_diri'] = this.menuDataDiri!.toJson();
    }
    return data;
  }
}

class MenuDataDiri {
  String? title;
  String? editTitle;
  String? terverifikasi;
  String? pengajuan;
  DataDiri? dataDiri;
  DataAlamat? dataAlamat;
  Button? button;
  Message? message;
  String? locale;

  MenuDataDiri(
      {this.title,
        this.editTitle,
        this.terverifikasi,
        this.pengajuan,
        this.dataDiri,
        this.dataAlamat,
        this.button,
        this.message,
        this.locale});

  MenuDataDiri.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    editTitle = json['edit_title'];
    terverifikasi = json['terverifikasi'];
    pengajuan = json['pengajuan'];
    dataDiri = json['data_diri'] != null
        ? new DataDiri.fromJson(json['data_diri'])
        : null;
    dataAlamat = json['data_alamat'] != null
        ? new DataAlamat.fromJson(json['data_alamat'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['edit_title'] = this.editTitle;
    data['terverifikasi'] = this.terverifikasi;
    data['pengajuan'] = this.pengajuan;
    if (this.dataDiri != null) {
      data['data_diri'] = this.dataDiri!.toJson();
    }
    if (this.dataAlamat != null) {
      data['data_alamat'] = this.dataAlamat!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class DataDiri {
  String? header;
  String? nomorIndukKaryawan;
  String? namaLengkap;
  String? pendidikanTerakhir;
  String? gelarDepan;
  String? gelarBelakang;
  String? jenisKelamin;
  String? golonganDarah;
  String? tempatLahir;
  String? tanggalLahir;
  String? email;
  String? noTelepon;
  String? agama;
  String? noIndukKependudukan;
  String? noBpjsKes;
  String? noBpjsTk;
  String? noAsuransi;

  DataDiri(
      {this.header,
        this.nomorIndukKaryawan,
        this.namaLengkap,
        this.pendidikanTerakhir,
        this.gelarDepan,
        this.gelarBelakang,
        this.jenisKelamin,
        this.golonganDarah,
        this.tempatLahir,
        this.tanggalLahir,
        this.email,
        this.noTelepon,
        this.agama,
        this.noIndukKependudukan,
        this.noBpjsKes,
        this.noBpjsTk,
        this.noAsuransi});

  DataDiri.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    nomorIndukKaryawan = json['nomor_induk_karyawan'];
    namaLengkap = json['nama_lengkap'];
    pendidikanTerakhir = json['pendidikan_terakhir'];
    gelarDepan = json['gelar_depan'];
    gelarBelakang = json['gelar_belakang'];
    jenisKelamin = json['jenis_kelamin'];
    golonganDarah = json['golongan_darah'];
    tempatLahir = json['tempat_lahir'];
    tanggalLahir = json['tanggal_lahir'];
    email = json['email'];
    noTelepon = json['no_telepon'];
    agama = json['agama'];
    noIndukKependudukan = json['no_induk_kependudukan'];
    noBpjsKes = json['no_bpjs_kes'];
    noBpjsTk = json['no_bpjs_tk'];
    noAsuransi = json['no_asuransi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['nomor_induk_karyawan'] = this.nomorIndukKaryawan;
    data['nama_lengkap'] = this.namaLengkap;
    data['pendidikan_terakhir'] = this.pendidikanTerakhir;
    data['gelar_depan'] = this.gelarDepan;
    data['gelar_belakang'] = this.gelarBelakang;
    data['jenis_kelamin'] = this.jenisKelamin;
    data['golongan_darah'] = this.golonganDarah;
    data['tempat_lahir'] = this.tempatLahir;
    data['tanggal_lahir'] = this.tanggalLahir;
    data['email'] = this.email;
    data['no_telepon'] = this.noTelepon;
    data['agama'] = this.agama;
    data['no_induk_kependudukan'] = this.noIndukKependudukan;
    data['no_bpjs_kes'] = this.noBpjsKes;
    data['no_bpjs_tk'] = this.noBpjsTk;
    data['no_asuransi'] = this.noAsuransi;
    return data;
  }
}

class DataAlamat {
  String? header;
  String? provinsi;
  String? kabupaten;
  String? kecamatan;
  String? kelurahan;
  String? rt;
  String? rw;
  String? alamatDomisili;
  String? kodePos;

  DataAlamat(
      {this.header,
        this.provinsi,
        this.kabupaten,
        this.kecamatan,
        this.kelurahan,
        this.rt,
        this.rw,
        this.alamatDomisili,
        this.kodePos});

  DataAlamat.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    provinsi = json['provinsi'];
    kabupaten = json['kabupaten'];
    kecamatan = json['kecamatan'];
    kelurahan = json['kelurahan'];
    rt = json['rt'];
    rw = json['rw'];
    alamatDomisili = json['alamat_domisili'];
    kodePos = json['kode_pos'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['provinsi'] = this.provinsi;
    data['kabupaten'] = this.kabupaten;
    data['kecamatan'] = this.kecamatan;
    data['kelurahan'] = this.kelurahan;
    data['rt'] = this.rt;
    data['rw'] = this.rw;
    data['alamat_domisili'] = this.alamatDomisili;
    data['kode_pos'] = this.kodePos;
    return data;
  }
}

class Button {
  String? ubahData;
  String? hapusData;
  String? ajukanPerubahanData;
  String? ajukan;
  String? catatanRevisi;
  String? btnTutup;
  String? btnBatal;
  String? btnYa;

  Button(
      {this.ubahData,
        this.hapusData,
        this.ajukanPerubahanData,
        this.ajukan,
        this.catatanRevisi,
        this.btnTutup,
        this.btnBatal,
        this.btnYa});

  Button.fromJson(Map<String, dynamic> json) {
    ubahData = json['ubah_data'];
    hapusData = json['hapus_data'];
    ajukanPerubahanData = json['ajukan_perubahan_data'];
    ajukan = json['ajukan'];
    catatanRevisi = json['catatan_revisi'];
    btnTutup = json['btn_tutup'];
    btnBatal = json['btn_batal'];
    btnYa = json['btn_ya'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ubah_data'] = this.ubahData;
    data['hapus_data'] = this.hapusData;
    data['ajukan_perubahan_data'] = this.ajukanPerubahanData;
    data['ajukan'] = this.ajukan;
    data['catatan_revisi'] = this.catatanRevisi;
    data['btn_tutup'] = this.btnTutup;
    data['btn_batal'] = this.btnBatal;
    data['btn_ya'] = this.btnYa;
    return data;
  }
}

class Message {
  String? hapusData;
  String? pengajuanHapus;
  String? nikEmpty;
  String? namaLengkapEmpty;
  String? pendidikanTerakhirEmpty;
  String? jenisKelaminEmpty;
  String? tempatLahirEmpty;
  String? tanggalLahirEmpty;
  String? teleponEmpty;
  String? emailEmpty;
  String? agamaEmpty;
  String? noIndukKtp;
  String? provinsiEmpty;
  String? kabupatenEmpty;
  String? kecamatanEmpty;
  String? kelurahanEmpty;
  String? alamatDomisiliEmpty;

  Message(
      {this.hapusData,
        this.pengajuanHapus,
        this.nikEmpty,
        this.namaLengkapEmpty,
        this.pendidikanTerakhirEmpty,
        this.jenisKelaminEmpty,
        this.tempatLahirEmpty,
        this.tanggalLahirEmpty,
        this.teleponEmpty,
        this.emailEmpty,
        this.agamaEmpty,
        this.noIndukKtp,
        this.provinsiEmpty,
        this.kabupatenEmpty,
        this.kecamatanEmpty,
        this.kelurahanEmpty,
        this.alamatDomisiliEmpty});

  Message.fromJson(Map<String, dynamic> json) {
    hapusData = json['hapus_data'];
    pengajuanHapus = json['pengajuan_hapus'];
    nikEmpty = json['nik_empty'];
    namaLengkapEmpty = json['nama_lengkap_empty'];
    pendidikanTerakhirEmpty = json['pendidikan_terakhir_empty'];
    jenisKelaminEmpty = json['jenis_kelamin_empty'];
    tempatLahirEmpty = json['tempat_lahir_empty'];
    tanggalLahirEmpty = json['tanggal_lahir_empty'];
    teleponEmpty = json['telepon_empty'];
    emailEmpty = json['email_empty'];
    agamaEmpty = json['agama_empty'];
    noIndukKtp = json['no_induk_ktp'];
    provinsiEmpty = json['provinsi_empty'];
    kabupatenEmpty = json['kabupaten_empty'];
    kecamatanEmpty = json['kecamatan_empty'];
    kelurahanEmpty = json['kelurahan_empty'];
    alamatDomisiliEmpty = json['alamat_domisili_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hapus_data'] = this.hapusData;
    data['pengajuan_hapus'] = this.pengajuanHapus;
    data['nik_empty'] = this.nikEmpty;
    data['nama_lengkap_empty'] = this.namaLengkapEmpty;
    data['pendidikan_terakhir_empty'] = this.pendidikanTerakhirEmpty;
    data['jenis_kelamin_empty'] = this.jenisKelaminEmpty;
    data['tempat_lahir_empty'] = this.tempatLahirEmpty;
    data['tanggal_lahir_empty'] = this.tanggalLahirEmpty;
    data['telepon_empty'] = this.teleponEmpty;
    data['email_empty'] = this.emailEmpty;
    data['agama_empty'] = this.agamaEmpty;
    data['no_induk_ktp'] = this.noIndukKtp;
    data['provinsi_empty'] = this.provinsiEmpty;
    data['kabupaten_empty'] = this.kabupatenEmpty;
    data['kecamatan_empty'] = this.kecamatanEmpty;
    data['kelurahan_empty'] = this.kelurahanEmpty;
    data['alamat_domisili_empty'] = this.alamatDomisiliEmpty;
    return data;
  }
}


