import 'dart:convert';

PageDashboardModel pageDashboardModelFromJson(String str) =>
    PageDashboardModel.fromJson(json.decode(str));

String pageDashboardModelToJson(PageDashboardModel data) =>
    json.encode(data.toJson());

class PageDashboardModel {
  MenuBeranda? menuBeranda;

  PageDashboardModel({this.menuBeranda});

  PageDashboardModel.fromJson(Map<String, dynamic> json) {
    menuBeranda = json['menu_beranda'] != null
        ? new MenuBeranda.fromJson(json['menu_beranda'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuBeranda != null) {
      data['menu_beranda'] = this.menuBeranda!.toJson();
    }
    return data;
  }
}

class MenuBeranda {
  MenuUtama? menuUtama;
  RakapAbsensiBulanIni? rekapAbsensiBulanIni;
  DataKomponenTambahan? dataKomponenTambahan;

  MenuBeranda(
      {this.menuUtama, this.rekapAbsensiBulanIni, this.dataKomponenTambahan});

  MenuBeranda.fromJson(Map<String, dynamic> json) {
    menuUtama = json['menu_utama'] != null
        ? new MenuUtama.fromJson(json['menu_utama'])
        : null;
    rekapAbsensiBulanIni = json['rekap_absensi_bulan_ini'] != null
        ? new RakapAbsensiBulanIni.fromJson(json['rekap_absensi_bulan_ini'])
        : null;
    dataKomponenTambahan = json['data_komponen_tambahan'] != null
        ? new DataKomponenTambahan.fromJson(json['data_komponen_tambahan'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuUtama != null) {
      data['menu_utama'] = this.menuUtama!.toJson();
    }
    if (this.rekapAbsensiBulanIni != null) {
      data['rekap_absensi_bulan_ini'] = this.rekapAbsensiBulanIni!.toJson();
    }
    if (this.dataKomponenTambahan != null) {
      data['data_komponen_tambahan'] = this.dataKomponenTambahan!.toJson();
    }
    return data;
  }
}

class MenuUtama {
  String? title;
  Data? data;

  MenuUtama({this.title, this.data});

  MenuUtama.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  String? izin;
  String? lembur;
  String? shift;
  String? reimbursement;
  String? infoGaji;
  String? aktivitas;
  String? berita;
  String? slipGaji;
  String? patroli;

  Data(
      {this.izin,
      this.lembur,
      this.shift,
      this.reimbursement,
      this.infoGaji,
      this.aktivitas,
      this.berita,
      this.slipGaji,
      this.patroli});

  Data.fromJson(Map<String, dynamic> json) {
    izin = json['izin'];
    lembur = json['lembur'];
    shift = json['shift'];
    reimbursement = json['reimbursement'];
    infoGaji = json['info_gaji'];
    aktivitas = json['aktivitas'];
    berita = json['berita'];
    slipGaji = json['slip_gaji'];
    patroli = json['patroli'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['izin'] = this.izin;
    data['lembur'] = this.lembur;
    data['shift'] = this.shift;
    data['reimbursement'] = this.reimbursement;
    data['info_gaji'] = this.infoGaji;
    data['aktivitas'] = this.aktivitas;
    data['berita'] = this.berita;
    data['slip_gaji'] = this.slipGaji;
    data['patroli'] = this.patroli;
    return data;
  }
}

class RakapAbsensiBulanIni {
  String? title;
  DataRekap? dataRekap;

  RakapAbsensiBulanIni({this.title, this.dataRekap});

  RakapAbsensiBulanIni.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    dataRekap =
        json['data'] != null ? new DataRekap.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.dataRekap != null) {
      data['data'] = this.dataRekap!.toJson();
    }
    return data;
  }
}

class DataRekap {
  String? hadir;
  String? izin;
  String? sisaCuti;
  String? hari;
  String? masuk;
  String? pulang;

  DataRekap({this.hadir, this.izin, this.sisaCuti});

  DataRekap.fromJson(Map<String, dynamic> json) {
    hadir = json['hadir'];
    izin = json['izin'];
    sisaCuti = json['sisa_cuti'];
    hari = json['hari'];
    masuk = json['masuk'];
    pulang = json['pulang'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hadir'] = this.hadir;
    data['izin'] = this.izin;
    data['sisa_cuti'] = this.sisaCuti;
    data['hari'] = this.hari;
    data['masuk'] = this.masuk;
    data['pulang'] = this.pulang;
    return data;
  }
}

class DataKomponenTambahan {
  String? title;
  KomponenTambahan? dataKomponen;

  DataKomponenTambahan({this.title, this.dataKomponen});

  DataKomponenTambahan.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    dataKomponen = json['data'] != null
        ? new KomponenTambahan.fromJson(json['data'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.dataKomponen != null) {
      data['data'] = this.dataKomponen!.toJson();
    }
    return data;
  }
}

class KomponenTambahan {
  String? absensi_hari_ini;

  KomponenTambahan({this.absensi_hari_ini});

  KomponenTambahan.fromJson(Map<String, dynamic> json) {
    absensi_hari_ini = json['absensi_hari_ini'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['absensi_hari_ini'] = this.absensi_hari_ini;
    return data;
  }
}
