import 'dart:convert';

PageBeritaPengumumanModel pageBeritaPengumumanModelFromJson(String str) => PageBeritaPengumumanModel.fromJson(json.decode(str));

String pageBeritaPengumumanModelToJson(PageBeritaPengumumanModel data) => json.encode(data.toJson());

class PageBeritaPengumumanModel {
  MenuBeritaPengumuman? menuBeritaPengumuman;

  PageBeritaPengumumanModel({this.menuBeritaPengumuman});

  PageBeritaPengumumanModel.fromJson(Map<String, dynamic> json) {
    menuBeritaPengumuman = json['menu_berita_pengumuman'] != null
        ? new MenuBeritaPengumuman.fromJson(json['menu_berita_pengumuman'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuBeritaPengumuman != null) {
      data['menu_berita_pengumuman'] = this.menuBeritaPengumuman!.toJson();
    }
    return data;
  }
}

class MenuBeritaPengumuman {
  String? title;
  String? tabBerita;
  String? tabPengumuman;
  String? detailBerita;
  String? detailPengumuman;

  MenuBeritaPengumuman(
      {this.title,
        this.tabBerita,
        this.tabPengumuman,
        this.detailBerita,
        this.detailPengumuman});

  MenuBeritaPengumuman.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    tabBerita = json['tab_berita'];
    tabPengumuman = json['tab_pengumuman'];
    detailBerita = json['detail_berita'];
    detailPengumuman = json['detail_pengumuman'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['tab_berita'] = this.tabBerita;
    data['tab_pengumuman'] = this.tabPengumuman;
    data['detail_berita'] = this.detailBerita;
    data['detail_pengumuman'] = this.detailPengumuman;
    return data;
  }
}
