import 'dart:convert';

PageAkunModel pageAkunModelFromJson(String str) => PageAkunModel.fromJson(json.decode(str));

String pageAkunModelToJson(PageAkunModel data) => json.encode(data.toJson());

class PageAkunModel {
  MenuAkun? menuAkun;

  PageAkunModel({this.menuAkun});

  PageAkunModel.fromJson(Map<String, dynamic> json) {
    menuAkun = json['menu_akun'] != null
        ? new MenuAkun.fromJson(json['menu_akun'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuAkun != null) {
      data['menu_akun'] = this.menuAkun!.toJson();
    }
    return data;
  }
}

class MenuAkun {
  String? title;
  String? locale;
  String? jabatan;
  String? departemen;
  String? dataDiri;
  String? dataKeluarga;
  String? dataPendidikan;
  String? pengalamanKerja;
  String? kelengkapanFile;
  String? kontakSemuaPegawai;
  String? bahasa;
  String? pilihBahasa;
  String? historyPengajuanData;
  String? dataWajah;
  String? teregistrasi;
  String? belumRegistrasi;
  String? lihat;
  String? gantiPassword;
  String? logout;
  String? messageExit;
  String? btnYa;
  String? btnNo;
  String? btnBatalkan;
  String? btnTerapkan;
  String? versi;

  MenuAkun(
      {this.title,
        this.locale,
        this.jabatan,
        this.departemen,
        this.dataDiri,
        this.dataKeluarga,
        this.dataPendidikan,
        this.pengalamanKerja,
        this.kelengkapanFile,
        this.kontakSemuaPegawai,
        this.bahasa,
        this.pilihBahasa,
        this.historyPengajuanData,
        this.dataWajah,
        this.teregistrasi,
        this.belumRegistrasi,
        this.lihat,
        this.gantiPassword,
        this.logout,
        this.messageExit,
        this.btnYa,
        this.btnNo,
        this.btnBatalkan,
        this.btnTerapkan,
        this.versi});

  MenuAkun.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    jabatan = json['jabatan'];
    departemen = json['departemen'];
    dataDiri = json['data_diri'];
    dataKeluarga = json['data_keluarga'];
    dataPendidikan = json['data_pendidikan'];
    pengalamanKerja = json['pengalaman_kerja'];
    kelengkapanFile = json['kelengkapan_file'];
    kontakSemuaPegawai = json['kontak_semua_pegawai'];
    bahasa = json['bahasa'];
    pilihBahasa = json['pilih_bahasa'];
    historyPengajuanData = json['history_pengajuan_data'];
    dataWajah = json['data_wajah'];
    teregistrasi = json['teregistrasi'];
    belumRegistrasi = json['belum_registrasi'];
    lihat = json['lihat'];
    gantiPassword = json['ganti_password'];
    logout = json['logout'];
    messageExit = json['message_exit'];
    btnYa = json['btn_ya'];
    btnNo = json['btn_no'];
    btnBatalkan = json['btn_batalkan'];
    btnTerapkan = json['btn_terapkan'];
    versi = json['versi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['jabatan'] = this.jabatan;
    data['departemen'] = this.departemen;
    data['data_diri'] = this.dataDiri;
    data['data_keluarga'] = this.dataKeluarga;
    data['data_pendidikan'] = this.dataPendidikan;
    data['pengalaman_kerja'] = this.pengalamanKerja;
    data['kelengkapan_file'] = this.kelengkapanFile;
    data['kontak_semua_pegawai'] =this.kontakSemuaPegawai;
    data['bahasa'] = this.bahasa;
    data['pilih_bahasa'] = this.pilihBahasa;
    data['history_pengajuan_data'] = this.historyPengajuanData;
    data['data_wajah'] = this.dataWajah;
    data['teregistrasi'] = this.teregistrasi;
    data['belum_registrasi'] = this.belumRegistrasi;
    data['lihat'] = this.lihat;
    data['ganti_password'] = this.gantiPassword;
    data['logout'] = this.logout;
    data['message_exit'] = this.messageExit;
    data['btn_ya'] = this.btnYa;
    data['btn_no'] = this.btnNo;
    data['btn_batalkan'] = this.btnBatalkan;
    data['btn_terapkan'] = this.btnTerapkan;
    data['versi'] = this.versi;
    return data;
  }
}
