// To parse this JSON data, do
//
//     final dataPengajuanKpiWithBobotRespon = dataPengajuanKpiWithBobotResponFromJson(jsonString);

import 'dart:convert';

DataPengajuanKpiWithBobotRespon dataPengajuanKpiWithBobotResponFromJson(
        String str) =>
    DataPengajuanKpiWithBobotRespon.fromJson(json.decode(str));

String dataPengajuanKpiWithBobotResponToJson(
        DataPengajuanKpiWithBobotRespon data) =>
    json.encode(data.toJson());

class DataPengajuanKpiWithBobotRespon {
  bool? success;
  String? message;
  DataPengajuan? data;

  DataPengajuanKpiWithBobotRespon({
    this.success,
    this.message,
    this.data,
  });

  factory DataPengajuanKpiWithBobotRespon.fromJson(Map<String, dynamic> json) =>
      DataPengajuanKpiWithBobotRespon(
        success: json["success"],
        message: json["message"],
        data: DataPengajuan.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data!.toJson(),
      };
}

class DataPengajuan {
  String? idKaryawan;
  String? namaLengkap;
  String? tahun;
  String? bulan;
  String? masterBobot;
  String? bobot;
  List<ListElement>? list;

  DataPengajuan({
    this.idKaryawan,
    this.namaLengkap,
    this.tahun,
    this.bulan,
    this.masterBobot,
    this.bobot,
    this.list,
  });

  factory DataPengajuan.fromJson(Map<String, dynamic> json) => DataPengajuan(
        idKaryawan: json["id_Karyawan"],
        namaLengkap: json["nama_lengkap"],
        tahun: json["tahun"],
        bulan: json["bulan"],
        masterBobot: json["master_bobot"],
        bobot: json["bobot"],
        list: List<ListElement>.from(
            json["list"].map((x) => ListElement.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id_Karyawan": idKaryawan,
        "nama_lengkap": namaLengkap,
        "tahun": tahun,
        "bulan": bulan,
        "master_bobot": masterBobot,
        "bobot": bobot,
        "list": List<dynamic>.from(list!.map((x) => x.toJson())),
      };
}

class ListElement {
  String? idObjectM;
  String? nmObject;
  int? noUrut;
  String? idCompany;
  String? userInput;
  String? tglInput;
  String? userUpdate;
  String? tglUpdate;
  List<ListItem>? listItem;

  ListElement({
    this.idObjectM,
    this.nmObject,
    this.noUrut,
    this.idCompany,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
    this.listItem,
  });

  factory ListElement.fromJson(Map<String, dynamic> json) => ListElement(
        idObjectM: json["id_object_m"],
        nmObject: json["nm_object"],
        noUrut: json["no_urut"],
        idCompany: json["id_company"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
        listItem: List<ListItem>.from(
            json["list_item"].map((x) => ListItem.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id_object_m": idObjectM,
        "nm_object": nmObject,
        "no_urut": noUrut,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
        "list_item": List<dynamic>.from(listItem!.map((x) => x.toJson())),
      };
}

class ListItem {
  String? idPiTrx;
  String? idKaryawan;
  int? tahun;
  int? bulan;
  String? idObject;
  String? nmObject;
  int? noUrutObject;
  String? nmIndikator;
  String? target;
  int? bobot;
  String? poin1;
  String? poin2;
  String? poin3;
  String? poin4;
  String? poin5;
  int? noUrutIndikator;
  int? actualPoin;
  String? actualBukti;
  int? actualPoinApproval;
  String? idCompany;
  String? userInput;
  String? tglInput;
  String? userUpdate;
  String? tglUpdate;

  ListItem({
    this.idPiTrx,
    this.idKaryawan,
    this.tahun,
    this.bulan,
    this.idObject,
    this.nmObject,
    this.noUrutObject,
    this.nmIndikator,
    this.target,
    this.bobot,
    this.poin1,
    this.poin2,
    this.poin3,
    this.poin4,
    this.poin5,
    this.noUrutIndikator,
    this.actualPoin,
    this.actualBukti,
    this.actualPoinApproval,
    this.idCompany,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
  });

  factory ListItem.fromJson(Map<String, dynamic> json) => ListItem(
        idPiTrx: json["id_pi_trx"],
        idKaryawan: json["id_karyawan"],
        tahun: json["tahun"],
        bulan: json["bulan"],
        idObject: json["id_object"],
        nmObject: json["nm_object"],
        noUrutObject: json["no_urut_object"],
        nmIndikator: json["nm_aspek_kinerja"],
        target: json["target"],
        bobot: json["bobot"],
        poin1: json["poin_1"],
        poin2: json["poin_2"],
        poin3: json["poin_3"],
        poin4: json["poin_4"],
        poin5: json["poin_5"],
        noUrutIndikator: json["no_urut_indikator"],
        actualPoin: json["actual_poin"],
        actualBukti: json["actual_bukti"],
        actualPoinApproval: json["actual_poin_approval"],
        idCompany: json["id_company"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
      );

  Map<String, dynamic> toJson() => {
        "id_pi_trx": idPiTrx,
        "id_karyawan": idKaryawan,
        "tahun": tahun,
        "bulan": bulan,
        "id_object": idObject,
        "nm_object": nmObject,
        "no_urut_object": noUrutObject,
        "nm_aspek_kinerja": nmIndikator,
        "target": target,
        "bobot": bobot,
        "poin_1": poin1,
        "poin_2": poin2,
        "poin_3": poin3,
        "poin_4": poin4,
        "poin_5": poin5,
        "no_urut_indikator": noUrutIndikator,
        "actual_poin": actualPoin,
        "actual_bukti": actualBukti,
        "actual_poin_approval": actualPoinApproval,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
      };
}

class ParsingModelKaryawanWithBobot {
  String? karyawan;
  String? id_karyawan;
  String? id_company;
  int? bulan;
  int? tahun;
  ParsingModelKaryawanWithBobot(
      {this.karyawan,
      this.id_karyawan,
      this.id_company,
      this.bulan,
      this.tahun});
}
