// To parse this JSON data, do
//
//     final dataPengajuanAspekKedisiplinan = dataPengajuanAspekKedisiplinanFromJson(jsonString);

import 'dart:convert';

DataPengajuanAspekKedisiplinan dataPengajuanAspekKedisiplinanFromJson(
        String str) =>
    DataPengajuanAspekKedisiplinan.fromJson(json.decode(str));

String dataPengajuanAspekKedisiplinanToJson(
        DataPengajuanAspekKedisiplinan data) =>
    json.encode(data.toJson());

class DataPengajuanAspekKedisiplinan {
  bool? success;
  String? message;
  DataAspekKedisiplinan? data;

  DataPengajuanAspekKedisiplinan({
    this.success,
    this.message,
    this.data,
  });

  factory DataPengajuanAspekKedisiplinan.fromJson(Map<String, dynamic> json) =>
      DataPengajuanAspekKedisiplinan(
        success: json["success"],
        message: json["message"],
        data: json["data"] == null ? null :DataAspekKedisiplinan.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null ? null :data!.toJson(),
      };
}

class DataAspekKedisiplinan {
  String? jumlahSkor;
  List<Item>? item;

  DataAspekKedisiplinan({
    this.jumlahSkor,
    this.item,
  });

  factory DataAspekKedisiplinan.fromJson(Map<String, dynamic> json) =>
      DataAspekKedisiplinan(
        jumlahSkor: json["jumlah_skor"],
        item: List<Item>.from(json["item"].map((x) => Item.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "jumlah_skor": jumlahSkor,
        "item": List<dynamic>.from(item!.map((x) => x.toJson())),
      };
}

class Item {
  int? tahun;
  int? bulan;
  String? skor;
  String? jenis;
  int? jumlah;
  int? poin;
  int? bobot;
  String? keterangan;

  Item({
    this.tahun,
    this.bulan,
    this.skor,
    this.jenis,
    this.jumlah,
    this.poin,
    this.bobot,
    this.keterangan,
  });

  factory Item.fromJson(Map<String, dynamic> json) => Item(
        tahun: json["tahun"],
        bulan: json["bulan"],
        skor: json["skor"],
        jenis: json["jenis"],
        jumlah: json["jumlah"],
        poin: json["poin"],
        bobot: json["bobot"],
        keterangan: json["keterangan"],
      );

  Map<String, dynamic> toJson() => {
        "tahun": tahun,
        "bulan": bulan,
        "skor": skor,
        "jenis": jenis,
        "jumlah": jumlah,
        "poin": poin,
        "bobot": bobot,
        "keterangan": keterangan,
      };
}
