import 'dart:convert';

DataDiriRespon dataDiriResponFromJson(String str) =>
    DataDiriRespon.fromJson(json.decode(str));

String dataDiriResponToJson(DataDiriRespon data) => json.encode(data.toJson());

class DataDiriRespon {
  bool? success;
  String? message;
  DataDiri? data;

  DataDiriRespon({this.success, this.message, this.data});

  DataDiriRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    data = json['data'] != null ? new DataDiri.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}


JenisDataRespon jenisDataResponFromJson(String str) => JenisDataRespon.fromJson(json.decode(str));

String jenisDataResponToJson(JenisDataRespon data) => json.encode(data.toJson());

class JenisDataRespon {
  JenisDataRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<JenisData>? data;

  factory JenisDataRespon.fromJson(Map<String, dynamic> json) =>
      JenisDataRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null
            ? null
            : List<JenisData>.from(
            json["data"].map((x) => JenisData.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": data == null
        ? null
        : List<dynamic>.from(data!.map((x) => x.toJson())),
  };
}

class JenisData {
  JenisData({ this.id, this.nama });

  String? id;
  String? nama;

  factory JenisData.fromJson(Map<String, dynamic> json) => JenisData(
    id: json["id"] == null ? null : json["id"],
    nama: json["nama"] == null ? null : json["nama"]
  );

  Map<String, dynamic> toJson() => {
    "id": id == null ? null : id,
    "nama": nama == null ? null : nama
  };
}

class DataDiri {
  String? nik;
  String? namaLengkap;
  JenisData? pendidikanTerakhir;
  String? gelarDepan;
  String? gelarBelakang;
  JenisData? jenisKelamin;
  JenisData? golonganDarah;
  String? tempatLahir;
  String? tglLahir;
  String? telepon;
  String? email;
  JenisData? agama;
  JenisData? provinsi;
  JenisData? kabupaten;
  JenisData? kecamatan;
  JenisData? kelurahan;
  String? rt;
  String? rw;
  String? alamatDomisili;
  String? kodePos;
  String? statusApprove;
  String? messageStatus;
  String? keteranganRevisi;
  String? noKtp;
  String? noBPJSKes;
  String? noBPJSTk;
  String? noAsuransi;

  DataDiri(
      {this.nik,
        this.namaLengkap,
        this.pendidikanTerakhir,
        this.gelarDepan,
        this.gelarBelakang,
        this.jenisKelamin,
        this.golonganDarah,
        this.tempatLahir,
        this.tglLahir,
        this.telepon,
        this.email,
        this.agama,
        this.provinsi,
        this.kabupaten,
        this.kecamatan,
        this.kelurahan,
        this.rt,
        this.rw,
        this.alamatDomisili,
        this.kodePos,
        this.statusApprove,
        this.messageStatus,
        this.keteranganRevisi,
        this.noKtp,
        this.noBPJSKes,
        this.noBPJSTk,
        this.noAsuransi});

  DataDiri.fromJson(Map<String, dynamic> json) {
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    pendidikanTerakhir = json['pendidikan_terakhir'] != null
        ? new JenisData.fromJson(json['pendidikan_terakhir'])
        : null;
    gelarDepan = json['gelar_depan'];
    gelarBelakang = json['gelar_belakang'];
    jenisKelamin = json['jenis_kelamin'] != null
        ? new JenisData.fromJson(json['jenis_kelamin'])
        : null;
    golonganDarah = json['golongan_darah'] != null
        ? new JenisData.fromJson(json['golongan_darah'])
        : null;
    tempatLahir = json['tempat_lahir'];
    tglLahir = json['tgl_lahir'];
    telepon = json['telepon'];
    email = json['email'];
    agama = json['agama'] != null
        ? new JenisData.fromJson(json['agama'])
        : null;
    provinsi = json['id_prov'] != null
        ? new JenisData.fromJson(json['id_prov'])
        : null;
    kabupaten = json['id_kab'] != null
        ? new JenisData.fromJson(json['id_kab'])
        : null;
    kecamatan = json['id_kec'] != null
        ? new JenisData.fromJson(json['id_kec'])
        : null;
    kelurahan = json['id_kel'] != null
        ? new JenisData.fromJson(json['id_kel'])
        : null;
    rt = json['rt'];
    rw = json['rw'];
    alamatDomisili = json['alamat_domisili'];
    kodePos = json['kode_pos'];
    statusApprove = json['status'];
    messageStatus = json['message_status'];
    keteranganRevisi = json['ket_revisi'];
    noKtp = json['no_ktp'];
    noBPJSKes = json['no_bpjs_kes'];
    noBPJSTk = json['no_bpjs_tk'];
    noAsuransi = json['no_asuransi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    if (this.pendidikanTerakhir != null) {
      data['pendidikan_terakhir'] = this.pendidikanTerakhir!.toJson();
    }
    data['gelar_depan'] = this.gelarDepan;
    data['gelar_belakang'] = this.gelarBelakang;
    if (this.jenisKelamin != null) {
      data['jenis_kelamin'] = this.jenisKelamin!.toJson();
    }
    if (this.golonganDarah != null) {
      data['golongan_darah'] = this.golonganDarah!.toJson();
    }
    data['tempat_lahir'] = this.tempatLahir;
    data['tgl_lahir'] = this.tglLahir;
    data['telepon'] = this.telepon;
    data['email'] = this.email;
    if (this.agama != null) {
      data['agama'] = this.agama!.toJson();
    }
    if (this.provinsi != null) {
      data['provinsi'] = this.provinsi!.toJson();
    }
    if (this.kabupaten != null) {
      data['kabupaten'] = this.kabupaten!.toJson();
    }
    if (this.kecamatan != null) {
      data['kecamatan'] = this.kecamatan!.toJson();
    }
    if (this.kelurahan != null) {
      data['kelurahan'] = this.kelurahan!.toJson();
    }
    data['rt'] = this.rt;
    data['rw'] = this.rw;
    data['alamat_domisili'] = this.alamatDomisili;
    data['kode_pos'] = this.kodePos;
    data['status'] = this.statusApprove;
    data['message_status'] = this.messageStatus;
    data['ket_revisi'] = this.keteranganRevisi;
    data['no_ktp'] = this.noKtp;
    data['no_bpjs_kes'] = this.noBPJSKes;
    data['no_bpjs_tk'] = this.noBPJSTk;
    data['no_asuransi'] = this.noAsuransi;
    return data;
  }
}

