import 'dart:convert';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';

DataKeluargaByIdRespon dataKeluargaByIdResponFromJson(String str) => DataKeluargaByIdRespon.fromJson(json.decode(str));

String dataKeluargaByIdResponToJson(DataKeluargaByIdRespon data) => json.encode(data.toJson());

class DataKeluargaByIdRespon {
  bool? success;
  String? message;
  List<DataDatakeluargaById>? dataDatakeluargaById;

  DataKeluargaByIdRespon({this.success, this.message, this.dataDatakeluargaById});

  DataKeluargaByIdRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datakeluarga'] != null) {
      dataDatakeluargaById = <DataDatakeluargaById>[];
      json['data_datakeluarga'].forEach((v) {
        dataDatakeluargaById!.add(new DataDatakeluargaById.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatakeluargaById != null) {
      data['data_datakeluarga'] =
          this.dataDatakeluargaById!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatakeluargaById {
  String? idKeluarga;
  String? idKaryawan;
  String? nik;
  String? namaLengkap;
  String? tempatLahir;
  String? tglLahir;
  JenisData? jenisKelamin;
  JenisData? agama;
  String? telepon;
  JenisData? pekerjaan;
  JenisData? hubKeluarga;
  JenisData? statusPerkawinan;
  String? noBpjs;
  JenisData? pendidikanTerakhir;
  String? tanggalPerkawinan;
  JenisData? status;
  String? idCompany;

  DataDatakeluargaById(
      {this.idKeluarga,
        this.idKaryawan,
        this.nik,
        this.namaLengkap,
        this.tempatLahir,
        this.tglLahir,
        this.jenisKelamin,
        this.agama,
        this.telepon,
        this.pekerjaan,
        this.hubKeluarga,
        this.statusPerkawinan,
        this.noBpjs,
        this.pendidikanTerakhir,
        this.tanggalPerkawinan,
        this.status,
        this.idCompany});

  DataDatakeluargaById.fromJson(Map<String, dynamic> json) {
    idKeluarga = json['id_keluarga'];
    idKaryawan = json['id_karyawan'];
    nik = json['nik'];
    namaLengkap = json['nama_lengkap'];
    tempatLahir = json['tempat_lahir'];
    tglLahir = json['tgl_lahir'];
    jenisKelamin = json['jenis_kelamin'] != null
        ? new JenisData.fromJson(json['jenis_kelamin'])
        : null;
    agama =
    json['agama'] != null ? new JenisData.fromJson(json['agama']) : null;
    telepon = json['telepon'];
    pekerjaan = json['pekerjaan'] != null
        ? new JenisData.fromJson(json['pekerjaan'])
        : null;
    hubKeluarga = json['hub_keluarga'] != null
        ? new JenisData.fromJson(json['hub_keluarga'])
        : null;
    statusPerkawinan = json['status_perkawinan'] != null
        ? new JenisData.fromJson(json['status_perkawinan'])
        : null;
    noBpjs = json['no_bpjs'];
    pendidikanTerakhir = json['pendidikan_terakhir'] != null
        ? new JenisData.fromJson(json['pendidikan_terakhir'])
        : null;
    tanggalPerkawinan = json['tanggal_perkawinan'];
    status = json['status'] != null
        ? new JenisData.fromJson(json['status'])
        : null;
    idCompany = json['id_company'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_keluarga'] = this.idKeluarga;
    data['id_karyawan'] = this.idKaryawan;
    data['nik'] = this.nik;
    data['nama_lengkap'] = this.namaLengkap;
    data['tempat_lahir'] = this.tempatLahir;
    data['tgl_lahir'] = this.tglLahir;
    if (this.jenisKelamin != null) {
      data['jenis_kelamin'] = this.jenisKelamin!.toJson();
    }
    if (this.agama != null) {
      data['agama'] = this.agama!.toJson();
    }
    data['telepon'] = this.telepon;
    if (this.pekerjaan != null) {
      data['pekerjaan'] = this.pekerjaan!.toJson();
    }
    if (this.hubKeluarga != null) {
      data['hub_keluarga'] = this.hubKeluarga!.toJson();
    }
    if (this.statusPerkawinan != null) {
      data['status_perkawinan'] = this.statusPerkawinan!.toJson();
    }
    data['no_bpjs'] = this.noBpjs;
    if (this.pendidikanTerakhir != null) {
      data['pendidikan_terakhir'] = this.pendidikanTerakhir!.toJson();
    }
    data['tanggal_perkawinan'] = this.tanggalPerkawinan;
    if (this.status != null) {
      data['status'] = this.status!.toJson();
    }
    data['id_company'] = this.idCompany;
    return data;
  }
}
