import 'dart:io';
import 'package:absenkuv3/Repository/Model/mDeviceInfo.dart';
import 'package:device_info_plus/device_info_plus.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/services.dart';

class DeviceInfo {
  Future<MDeviceinfo> getDeviceInfo() async {
    MDeviceinfo mDeviceinfo = new MDeviceinfo();
    try {
      DeviceInfoPlugin deviceInfo = DeviceInfoPlugin();
      if (Platform.isAndroid) {
        AndroidDeviceInfo androidInfo = await deviceInfo.androidInfo;
        mDeviceinfo.baseOS = androidInfo.version.baseOS;
        mDeviceinfo.brand = androidInfo.brand;
        mDeviceinfo.deviceId = androidInfo.id;
        mDeviceinfo.emulator = androidInfo.isPhysicalDevice;
        mDeviceinfo.model = androidInfo.model;
        mDeviceinfo.os = 'Android';
        mDeviceinfo.versiOS = androidInfo.version.release;
      } else if (Platform.isIOS) {
        IosDeviceInfo iosInfo = await deviceInfo.iosInfo;
        mDeviceinfo.baseOS = '';
        mDeviceinfo.brand = 'Apple';
        mDeviceinfo.deviceId = iosInfo.identifierForVendor;
        mDeviceinfo.emulator = iosInfo.isPhysicalDevice;
        mDeviceinfo.model = iosInfo.model;
        mDeviceinfo.os = 'IOS';
        mDeviceinfo.versiOS = iosInfo.utsname.version;
      }
      mDeviceinfo.tokenFCM = await FirebaseMessaging.instance.getToken();
      // print("tokennya ${await FirebaseMessaging.instance.getToken()}");
    } on PlatformException {
      // print('error');
    }
    return mDeviceinfo;
  }
}
