import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapTerlambatEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapTerlambatEvent extends SummaryRekapTerlambatEvent {
  ModelFilter? modelFilter;
  getSummaryRekapTerlambatEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapTerlambatState {
  DataSummary? data;
}

class getSummaryRekapTerlambatSuccessState extends SummaryRekapTerlambatState {
  getSummaryRekapTerlambatSuccessState(
      SummaryRekapTerlambatEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressTerlambatState extends SummaryRekapTerlambatState {}

class SummaryErrorState extends SummaryRekapTerlambatState {}

class SummaryRekapTerlambatBloc
    extends Bloc<SummaryRekapTerlambatEvent, SummaryRekapTerlambatState> {
  SummaryRekapTerlambatState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapTerlambatBloc(SummaryRekapTerlambatState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapTerlambatState> mapEventToState(
      SummaryRekapTerlambatEvent event) async* {
    if (event is getSummaryRekapTerlambatEvent) {
      yield SummaryProgressTerlambatState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/terlambat');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapTerlambatSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
