import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapTAPEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapTAPEvent extends SummaryRekapTAPEvent {
  ModelFilter? modelFilter;
  getSummaryRekapTAPEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapTAPState {
  DataSummary? data;
}

class getSummaryRekapTAPSuccessState extends SummaryRekapTAPState {
  getSummaryRekapTAPSuccessState(
      SummaryRekapTAPEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressTAPState extends SummaryRekapTAPState {}

class SummaryErrorState extends SummaryRekapTAPState {}

class SummaryRekapTAPBloc
    extends Bloc<SummaryRekapTAPEvent, SummaryRekapTAPState> {
  SummaryRekapTAPState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapTAPBloc(SummaryRekapTAPState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapTAPState> mapEventToState(
      SummaryRekapTAPEvent event) async* {
    if (event is getSummaryRekapTAPEvent) {
      yield SummaryProgressTAPState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/tap');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapTAPSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
