import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapPulangCepatEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapPulangCepatEvent extends SummaryRekapPulangCepatEvent {
  ModelFilter? modelFilter;
  getSummaryRekapPulangCepatEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapPulangCepatState {
  DataSummary? data;
}

class getSummaryRekapPulangCepatSuccessState extends SummaryRekapPulangCepatState {
  getSummaryRekapPulangCepatSuccessState(
      SummaryRekapPulangCepatEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressPulangCepatState extends SummaryRekapPulangCepatState {}

class SummaryErrorState extends SummaryRekapPulangCepatState {}

class SummaryRekapPulangCepatBloc
    extends Bloc<SummaryRekapPulangCepatEvent, SummaryRekapPulangCepatState> {
  SummaryRekapPulangCepatState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapPulangCepatBloc(SummaryRekapPulangCepatState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapPulangCepatState> mapEventToState(
      SummaryRekapPulangCepatEvent event) async* {
    if (event is getSummaryRekapPulangCepatEvent) {
      yield SummaryProgressPulangCepatState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/pulang-cepat');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapPulangCepatSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
