import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SisaCutiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSisaCutiEvent extends SisaCutiEvent {
  ModelFilter? modelFilter;
  getSisaCutiEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class GetDataSisaCutiDashboardEvent extends SisaCutiEvent {
  GetDataSisaCutiDashboardEvent(BuildContext _context) {
    context = _context;
  }
}

abstract class SisaCutiState {
  DataSummary? data;
}

class getSummarySuccessState extends SisaCutiState {
  getSummarySuccessState(SisaCutiEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class getSisaCutiDashboardSuccessState extends SisaCutiState {
  getSisaCutiDashboardSuccessState(SisaCutiEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummarySisaCutiProgressState extends SisaCutiState {}

class LoadMoreProgressState extends SisaCutiState {
  LoadMoreProgressState(DataSummary _data) {
    data = _data;
  }
}

class SisaCutiErrorState extends SisaCutiState {}

class SisaCutiDashboardBloc extends Bloc<SisaCutiEvent, SisaCutiState> {
  SisaCutiState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SisaCutiDashboardBloc(SisaCutiState initialState) : super(initialState);

  @override
  Stream<SisaCutiState> mapEventToState(SisaCutiEvent event) async* {
    if (event is GetDataSisaCutiDashboardEvent) {
      yield SummarySisaCutiProgressState();
      SummaryRespon cuti = await DashboardApi().getSisaCuti();
      if (cuti.success!) {
        listSummary = cuti.data;
        yield getSisaCutiDashboardSuccessState(event, listSummary);
      } else {
        yield SisaCutiErrorState();
      }
    }
  }
}
