import 'dart:async';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:url_launcher/url_launcher.dart';

import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/splashScreenApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Repository/DeviceInfo.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogUpdateApp.dart';
import 'package:absenkuv3/Repository/Model/mDeviceInfo.dart';
import 'NavigatorBloc.dart';

// -------------------- EVENTS --------------------
abstract class SplashEvent {}

class SplashStarted extends SplashEvent {
  final BuildContext context;
  SplashStarted(this.context);
}

class CheckVersionApp extends SplashEvent {
  final BuildContext context;
  CheckVersionApp(this.context);
}

// -------------------- STATES --------------------
abstract class SplashState {}

class SplashInitial extends SplashState {}

class SplashLoading extends SplashState {}

class SplashToLogin extends SplashState {}

class SplashToDashboard extends SplashState {}

class SplashError extends SplashState {
  final String message;
  SplashError(this.message);
}

// -------------------- BLOC --------------------
class SplashScreenBloc extends Bloc<SplashEvent, SplashState> {
  SplashScreenBloc() : super(SplashInitial()) {
    on<SplashStarted>(_onSplashStarted);
    on<CheckVersionApp>(_onCheckVersionApp);
  }

  Future<void> _onSplashStarted(SplashStarted event, Emitter<SplashState> emit) async {
    emit(SplashLoading());
    try {
      final context = event.context;
      final loginData = await sharedPreferences().getUserData();
      final deviceInfo = await DeviceInfo().getDeviceInfo();
      final versiMobile = ServerInfo.versionCode;

      final versionRespon = await SplashScreenApi().cekVersion(versiMobile, deviceInfo.os);

      if (versionRespon.success == true) {
        showDialog(
          barrierDismissible: false,
          context: context,
          builder: (ctx) => DialogUpdateApp(
            data: versionRespon,
            onClick: () => _launchUrl(versionRespon.version!.linkUpdate!),
            onClickSkip: () {
              if (loginData.dataLogin != null) {
                emit(SplashToDashboard());
              } else {
                emit(SplashToLogin());
              }
            },
          ),
        );
      } else {
        if (loginData.dataLogin != null) {
          emit(SplashToDashboard());
        } else {
          emit(SplashToLogin());
        }
      }
    } catch (e) {
      emit(SplashError('Terjadi kesalahan: ${e.toString()}'));
    }
  }

  Future<void> _onCheckVersionApp(CheckVersionApp event, Emitter<SplashState> emit) async {
    final versiMobile = ServerInfo.versionName;
    final versionRespon = await SplashScreenApi().versionApp(versiMobile);
    debugPrint(versionRespon.message);
  }

  Future<void> _launchUrl(String link) async {
    if (await canLaunch(link)) {
      await launch(link);
    } else {
      throw 'Could not launch $link';
    }
  }
}
