import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../CustomFunction.dart';

abstract class ShiftTemanDetailEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListShiftTemanDetailEvent extends ShiftTemanDetailEvent{
  ModelFilter? modelFilter;
  String? idMasterShift;
  String? tanggal;
  GetListShiftTemanDetailEvent(BuildContext _context, this.modelFilter, this.idMasterShift, this.tanggal){
    context = _context;
  }
}

class LoadMoreEvent extends ShiftTemanDetailEvent{
  late ScrollController scrollController;
  LoadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ShiftTemanDetailState{
  List<DataShiftTeman>? data;
  DataShiftTeman? dataAktivitas;
}

class GetListShiftTemanDetailSuccessState extends ShiftTemanDetailState{
  GetListShiftTemanDetailSuccessState(ShiftTemanDetailEvent _event, List<DataShiftTeman>? _data){
    data = _data;
  }
}

class ShiftTemanDetailProgressState extends ShiftTemanDetailState{}

class LoadMoreProgressState extends ShiftTemanDetailState{
  LoadMoreProgressState(List<DataShiftTeman>? _data){
    data = _data;
  }
}

class ShiftTemanDetailErrorState extends ShiftTemanDetailState{}

class ShiftTemanDetailBloc extends Bloc<ShiftTemanDetailEvent, ShiftTemanDetailState>{
  ShiftTemanDetailState? initialState;
  List<DataShiftTeman>? listShiftTeman;
  ModelFilter? modelFilter;
  String? idMasterShift;
  String? tanggal;
  int offset = 0;
  int limit = ServerInfo.limit;

  ShiftTemanDetailBloc(ShiftTemanDetailState initialState) : super(initialState);

  @override
  Stream<ShiftTemanDetailState> mapEventToState(ShiftTemanDetailEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetListShiftTemanDetailEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      idMasterShift = event.idMasterShift;
      tanggal = event.tanggal;
      yield ShiftTemanDetailProgressState();
      ShiftTemanKaryawanRespon shiftTemanRespon = await ShiftApi().getDataShiftTemanDetail(offset, modelFilter, idMasterShift, tanggal);
      if(shiftTemanRespon.success!){
        listShiftTeman = shiftTemanRespon.data;
        yield GetListShiftTemanDetailSuccessState(event, listShiftTeman);
      }
      else yield ShiftTemanDetailErrorState();
    }
    else if(event is LoadMoreEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listShiftTeman);
        ShiftTemanKaryawanRespon shiftTemanRespon = await ShiftApi().getDataShiftTemanDetail(offset, modelFilter, idMasterShift, tanggal);
        if(shiftTemanRespon.success!){
          listShiftTeman!.addAll(shiftTemanRespon.data!);
        }
        yield GetListShiftTemanDetailSuccessState(event, listShiftTeman);
      }
    }
  }
}