import 'package:absenkuv3/Repository/Model/SalesActivity/mTargetSales.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class TargetSalesEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class TargetSalesState {}

class GetTargetSalesEvent extends TargetSalesEvent {
  GetTargetSalesEvent(BuildContext _context) {
    context = _context;
  }
}

class TargetSalesSuccessState extends TargetSalesState {
  TargetSalesRespon? targetSalesRespon;
  TargetSalesSuccessState(this.targetSalesRespon) {}
}

class TargetSalesProgressState extends TargetSalesState {}

class TargetSalesFailedState extends TargetSalesState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  TargetSalesFailedState(this.message, this.scaffoldKey) {
    // showSnackBarDelayed(scaffoldKey, message);
  }
}

class TargetSalesBloc extends Bloc<TargetSalesEvent, TargetSalesState> {
  TargetSalesBloc(TargetSalesState initialState) : super(initialState);

  @override
  Stream<TargetSalesState> mapEventToState(TargetSalesEvent event) async* {
    if (event is GetTargetSalesEvent) {
      yield TargetSalesProgressState();
      TargetSalesRespon dataTargetSalesRespon = await SalesActivityApi().getDataTargetSales();
      if (dataTargetSalesRespon.success!)
        yield TargetSalesSuccessState(dataTargetSalesRespon);
      else
        yield TargetSalesFailedState(dataTargetSalesRespon.message, event.scaffoldKey);
    }
  }
}
