import 'package:bloc/bloc.dart';

abstract class StepperEvent {
  int? index;
}

class SetStepper extends StepperEvent {
  SetStepper(int _index) {
    index = _index;
  }
}

class StepperBloc extends Bloc<StepperEvent, int> {
  StepperBloc(int initialState) : super(initialState);

  @override
  Stream<int> mapEventToState(StepperEvent event) async* {
    if (event is SetStepper)
      yield event.index!;
    else
      yield state;
  }
}
