import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataAktivitasSales.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mJenisAktivitasSales.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class DataAktivitasSalesEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListDataAktivitasSalesEvent extends DataAktivitasSalesEvent {
  String? idPelanggan;
  String? idPipelineMain;
  getListDataAktivitasSalesEvent(BuildContext _context, this.idPelanggan, this.idPipelineMain) {
    context = _context;
  }
}

class addDataAktivitasSalesEvent extends DataAktivitasSalesEvent {
  GlobalKey<ScaffoldState>? scaffoldKey;
  String? idPelanggan;
  String? idPipelineMain;
  Data? jenisAktivitas;
  String? keterangan;
  String? lat;
  String? long;
  String? pathFoto;
  String? tanggal;
  String? jam;
  DataKanban? dataKanban;
  String? idTahapanM;
  addDataAktivitasSalesEvent(this.scaffoldKey, BuildContext _context,
      this.idPelanggan, this.idPipelineMain, this.jenisAktivitas, this.keterangan, this.lat, this.long, this.pathFoto, this.tanggal, this.jam, this.dataKanban, this.idTahapanM) {
    context = _context;
  }
}

class loadMoreEvent extends DataAktivitasSalesEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class DataAktivitasSalesState {
  List<DataAktivitasSales>? data;
}

class getListDataAktivitasSalesSuccessState extends DataAktivitasSalesState {
  getListDataAktivitasSalesSuccessState(DataAktivitasSalesEvent _event, List<DataAktivitasSales>? _data) {
    data = _data;
  }
}

class DataAktivitasSalesProgressState extends DataAktivitasSalesState {}

class LoadMoreProgressState extends DataAktivitasSalesState {
  LoadMoreProgressState(List<DataAktivitasSales>? _data) {
    data = _data;
  }
}

class DataAktivitasSalesErrorState extends DataAktivitasSalesState {}

class DataAktivitasSalesEmptyState extends DataAktivitasSalesState {}

class DataAktivitasSalesBloc extends Bloc<DataAktivitasSalesEvent, DataAktivitasSalesState> {
  ModelFilter? modelFilter;
  DataAktivitasSalesState? initialState;
  List<DataAktivitasSales>? listDataAktivitasSales;
  String? idPelanggan;
  String? idPipelineMain;
  int offset = 0;
  int limit = ServerInfo.limit;

  DataAktivitasSalesBloc(DataAktivitasSalesState initialState) : super(initialState);

  @override
  Stream<DataAktivitasSalesState> mapEventToState(DataAktivitasSalesEvent event) async* {
    if (event is getListDataAktivitasSalesEvent) {
      offset = 0;
      idPelanggan = event.idPelanggan;
      idPipelineMain = event.idPipelineMain;
      yield DataAktivitasSalesProgressState();
      DataAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDataAktivitasSales(event.idPelanggan, event.idPipelineMain, offset);
      if (dataAktivitasSalesRespon.success!) {
        listDataAktivitasSales = dataAktivitasSalesRespon.dataAktivitasSales;
        yield getListDataAktivitasSalesSuccessState(event, listDataAktivitasSales);
      } else if(!dataAktivitasSalesRespon.success!)
        yield DataAktivitasSalesEmptyState();
      else yield DataAktivitasSalesErrorState();
    }
    else if (event is loadMoreEvent) {
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listDataAktivitasSales);
        DataAktivitasSalesRespon dataAktivitasSalesRespon = await SalesActivityApi().getDataAktivitasSales(idPelanggan, idPipelineMain, offset);
        if (dataAktivitasSalesRespon.success!) {
          listDataAktivitasSales!.addAll(dataAktivitasSalesRespon.dataAktivitasSales!);
        }
        yield getListDataAktivitasSalesSuccessState(event, listDataAktivitasSales);
      }
    }
    else if(event is addDataAktivitasSalesEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await SalesActivityApi().addAktivitasSales(
          event.idPelanggan, event.idPipelineMain!, event.keterangan,
          event.jenisAktivitas!, event.lat, event.long, event.pathFoto, event.tanggal, event.jam);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        // BlocProvider.of<DataAktivitasSalesBloc>(event.context!)
        //     .add(getListDataAktivitasSalesEvent(event.context!, null));
        Future.delayed(Duration(milliseconds: 2000)).then((value) {
          // BlocProvider.of<NavigatorBloc>(event.context!)
          //     .add(NavigatePop(event.context));
          Navigator.pop(event.context!, ['', event.idTahapanM]);
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigateToReplaceDetailSalesActivityPage(event.context!, [event.dataKanban, 'Aktivitas', '', event.idTahapanM]));
        });
      }
    }
  }
}
