
import 'package:absenkuv3/Repository/Model/mPkwt.dart';
import 'package:absenkuv3/Repository/Service/pkwtApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgePkwtEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgePkwtState {}

class GetBadgePkwt extends BadgePkwtEvent {
  GetBadgePkwt(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class GetSuccessPkwt extends BadgePkwtState {
  BadgePkwt? badgePkwt;
  GetSuccessPkwt(this.badgePkwt) {}
}

class GetPkwtProgress extends BadgePkwtState {}

class GetFailed extends BadgePkwtState {
  String? message;
  GlobalKey<ScaffoldState>? scaffoldKey;
  GetFailed(this.message, this.scaffoldKey) {
  }
}

class BadgePkwtBloc extends Bloc<BadgePkwtEvent, BadgePkwtState> {
  BadgePkwtBloc(BadgePkwtState initialState) : super(initialState);

  @override
  Stream<BadgePkwtState> mapEventToState(BadgePkwtEvent event) async* {
    if (event is GetBadgePkwt) {
      yield GetPkwtProgress();
      debugPrint('statusbadge' + event.context!.toString());
      BadgePkwt badgePkwtRespon = await PkwtApi().badgePkwt();
      if (badgePkwtRespon.success!)
        yield GetSuccessPkwt(badgePkwtRespon);
      else
        yield GetFailed(badgePkwtRespon.message, event.scaffoldKey);
    }
  }
}
