import 'package:absenkuv3/Repository/Model/mPengumuman.dart';
import 'package:absenkuv3/Repository/Service/pengumumanApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailPengumumanEvent{}

class GetDetailPengumuman extends DetailPengumumanEvent{
  String? id;
  GetDetailPengumuman(this.id);
}

abstract class DetailPengumumanState{}

class DetailPengumumanProgress extends DetailPengumumanState{}

class DetailPengumumanSuccess extends DetailPengumumanState{
  PengumumanRespon pengumumanRespon;
  DetailPengumumanSuccess(this.pengumumanRespon);
}

class DetailPengumumanError extends DetailPengumumanState{}

class DetailPengumumanBloc extends Bloc<DetailPengumumanEvent, DetailPengumumanState>{
  DetailPengumumanBloc(DetailPengumumanState initialState) : super(initialState);



  @override
  Stream<DetailPengumumanState> mapEventToState(DetailPengumumanEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetDetailPengumuman){
      yield DetailPengumumanProgress();
      PengumumanRespon pengumumanRespon = await PengumumanApi().getDetailPengumuman(event.id);
      if(pengumumanRespon.success!) yield DetailPengumumanSuccess(pengumumanRespon);
      else yield DetailPengumumanError();
    }
  }
}