import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/Repository/Service/patroliApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class JadwalPatroliEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListJadwalPatroliEvent extends JadwalPatroliEvent {
  String? waktu;
  String? waktulocal;
  getListJadwalPatroliEvent(
      BuildContext? _context, this.waktu, this.waktulocal);
}

class loadMoreEvent extends JadwalPatroliEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey,
      ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class JadwalPatroliState {
  List<JadwalChekpoint>? data;
  JadwalChekpoint? dataJadwalChekpoint;
}

class getListJadwalPatroliSuccessState extends JadwalPatroliState {
  getListJadwalPatroliSuccessState(
      JadwalPatroliEvent _event, List<JadwalChekpoint>? _data) {
    data = _data;
  }
}

class getListJadwalPatroliSuccessFalseState extends JadwalPatroliState {
  getListJadwalPatroliSuccessFalseState(
      JadwalPatroliEvent _event, List<JadwalChekpoint>? _data) {
    data = _data;
  }
}

class cekValidWaktuPatroliEvent extends JadwalPatroliEvent {
  String? waktu;
  String? waktulocal;
  cekValidWaktuPatroliEvent(BuildContext? _context, this.waktu);
}

class JadwalPatroliProgressState extends JadwalPatroliState {}

class LoadMoreProgressState extends JadwalPatroliState {
  LoadMoreProgressState(List<JadwalChekpoint>? _data) {
    data = _data;
  }
}

class PeringatanState extends JadwalPatroliState {
  String jenisPeringatan;
  String message;
  PeringatanState(this.message, this.jenisPeringatan);
}

class JadwalPatroliErrorState extends JadwalPatroliState {}

class WaktuPatroliTidakValid extends JadwalPatroliState {}

class JadwalPatroliBloc
  extends Bloc<JadwalPatroliEvent, JadwalPatroliState> {
  JadwalPatroliState? initialState;
  List<JadwalChekpoint>? ListJadwalPatroli;
  int offset = 0;
  int limit = ServerInfo.limit;
  JadwalPatroliBloc() : super(JadwalPatroliProgressState());
  @override
  Stream<JadwalPatroliState> mapEventToState(
      JadwalPatroliEvent event) async* {
    if (event is getListJadwalPatroliEvent) {
      offset = 0;
      yield JadwalPatroliProgressState();
      JadwalChekpointRespone jadwalChekpointRespone = await PatroliApi()
          .getJadwalChekpoint(event.waktu, event.waktulocal);
      if (jadwalChekpointRespone.success!) {
        ListJadwalPatroli = jadwalChekpointRespone.data;
        yield getListJadwalPatroliSuccessState(event, ListJadwalPatroli);
      } else
        yield JadwalPatroliErrorState();
    }
  }
}
