import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class PageReimbursementEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class PageReimbursementState{}

class GetDataPageReimbursement extends PageReimbursementEvent{
  GetDataPageReimbursement(BuildContext _context){
    context = _context;
  }
}

class PageReimbursementGetSuccess extends PageReimbursementState{
  PageReimbursementModel? pageReimbursementModel;
  PageReimbursementGetSuccess(PageReimbursementModel? _data){
    pageReimbursementModel = _data;
  }
}

class PageReimbursementGetProgress extends PageReimbursementState{}


class PageReimbursementBloc extends Bloc<PageReimbursementEvent, PageReimbursementState>{
  PageReimbursementBloc(PageReimbursementState initialState) : super(initialState);


  @override
  Stream<PageReimbursementState> mapEventToState(PageReimbursementEvent event) async*{
    if(event is GetDataPageReimbursement){
      yield PageReimbursementGetProgress();
      PageReimbursementModel data = await PengaturanBahasa().reimbursement();
      yield PageReimbursementGetSuccess(data);
    }
  }
}