import 'package:absenkuv3/Repository/Model/PageModel/mAkunPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDashboardPage.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:flutter/services.dart' show rootBundle;
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class PageAkunEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class PageAkunState{}

class GetDataPageAkun extends PageAkunEvent{
  GetDataPageAkun(BuildContext _context){
    context = _context;
  }
}

class PageAkunGetSuccess extends PageAkunState{
  PageAkunModel? pageAkunModel;
  PageAkunGetSuccess(PageAkunModel? _data){
    pageAkunModel = _data;
  }
}

class PageAkunGetProgress extends PageAkunState{}


class PageAkunBloc extends Bloc<PageAkunEvent, PageAkunState>{
  PageAkunBloc(PageAkunState initialState) : super(initialState);


  @override
  Stream<PageAkunState> mapEventToState(PageAkunEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetDataPageAkun){
      yield PageAkunGetProgress();
      String jsonString;
      String bahasa = await sharedPreferences().getBahasa();
      if(bahasa == 'id'){
        jsonString = await rootBundle.loadString('assets/id/akun.json');
      }else{
        jsonString = await rootBundle.loadString('assets/en/akun.json');
      }
      PageAkunModel data = pageAkunModelFromJson(jsonString);
      yield PageAkunGetSuccess(data);
    }
  }
}