import 'dart:async';
import 'package:absenkuv3/Bloc/BadgeNotifBloc.dart';
import 'package:absenkuv3/Repository/Model/mDataNotif.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/Akun/notifikasiAkunApi.dart';
import 'package:absenkuv3/Repository/Service/notifApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class NotifEvent {
  BuildContext? context;
  String? konteks;
  String? idNotif;
  String? idKaryawan;
  String? idCompany;
  int? bulan;
  int? tahun;
  String? status;
}

abstract class NotifState {
  List<Data>? listNotif;
}

class InitStateEvent extends NotifEvent {
  InitStateEvent(BuildContext _context) {
    context = _context;
  }
}

class NotifDataEvent extends NotifEvent {
  NotifDataEvent(BuildContext _context, String _konteks) {
    context = _context;
    konteks = _konteks;
  }
}

class loadMoreEvent extends NotifEvent {
  late ScrollController scrollController;
  loadMoreEvent(ScrollController _scrollController, String _konteks) {
    scrollController = _scrollController;
    konteks = _konteks;
  }
}

class LoadMoreProgressState extends NotifState {
  LoadMoreProgressState(List<Data>? _data) {
    listNotif = _data;
  }
}

class BacaNotif extends NotifEvent {
  BacaNotif(String? _idNotif, String? _jenis, BuildContext _context) {
    idNotif = _idNotif;
    konteks = _jenis;
    context = _context;
  }
}

class BacaNotifAkun extends NotifEvent {
  BacaNotifAkun(String? _idNotif, BuildContext _context) {
    idNotif = _idNotif;
    context = _context;
  }
}

class BacaNotifNotifKpi extends NotifEvent {
  BacaNotifNotifKpi(String? id_karyawan, String? id_company, int? Bulan,
      int? Tahun, String Status) {
    idKaryawan = id_karyawan;
    idCompany = id_company;
    bulan = Bulan;
    tahun = Tahun;
    status = Status;
  }
}

class SuccessNotifState extends NotifState {
  SuccessNotifState(List<Data>? _listNotif) {
    listNotif = _listNotif;
  }
}

class SuccessBacaNotifState extends NotifState {
  SuccessBacaNotifState(bool? success);
}

class ProgressNotifState extends NotifState {}

class ErrorNotifState extends NotifState {}

class NotifBloc extends Bloc<NotifEvent, NotifState> {
  NotifBloc(NotifState initialState) : super(initialState);
  List<Data>? listNotif;
  int offset = 0;
  int limit = ServerInfo.limit;
  @override
  Stream<NotifState> mapEventToState(NotifEvent event) async* {
    if (event is InitStateEvent) {
    } else if (event is NotifDataEvent) {
      offset = 0;
      debugPrint(event.konteks! + ' konteks');
      debugPrint(offset.toString());
      yield ProgressNotifState();
      Datanotif data = await NotifApi().notifData(event.konteks!, offset);
      if (data.success!) {
        listNotif = data.data;
        yield SuccessNotifState(listNotif);
      } else {
        yield ErrorNotifState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        debugPrint(offset.toString() + ' offset');
        debugPrint(listNotif.toString());
        yield LoadMoreProgressState(listNotif);
        Datanotif data = await NotifApi().notifData(event.konteks!, offset);
        if (data.success!) {
          listNotif!.addAll(data.data!);
        }
        yield SuccessNotifState(listNotif);
      }
    } else if (event is BacaNotifNotifKpi) {
      debugPrint('baca notif Kpi');
      BasicRespon basicRespon = await NotifApi().bacaKpi(event.idKaryawan,
          event.idCompany, event.bulan, event.tahun, event.status);
      if (basicRespon.success!) {
        // BlocProvider.of<BadgeNotifBloc>(event.context!)
        //     .add(GetBadgeNotif(event.context!));
        yield SuccessBacaNotifState(basicRespon.success!);
      }
      yield ErrorNotifState();
    } else if (event is BacaNotif) {
      debugPrint('baca notif');
      BasicRespon basicRespon =
          await NotifApi().baca(event.idNotif, event.konteks);
      Future.delayed(Duration(milliseconds: 800)).then((value) {
        BlocProvider.of<BadgeNotifBloc>(event.context!)
            .add(GetBadgeNotif(event.context!));
      });
      if (basicRespon.success!) {
        yield SuccessBacaNotifState(basicRespon.success!);
      }
      // yield ErrorNotifState();
      debugPrint('basicRespon' + basicRespon.message!);
    } else if (event is BacaNotifAkun) {
      debugPrint('baca notif akun');
      BasicRespon basicRespon = await NotifikasiAkunApi().baca(event.idNotif);
    }
  }
}
