import 'package:bloc/bloc.dart';

abstract class NavbarEvent {
  int? index;
}

class SetNavbar extends NavbarEvent {
  SetNavbar(int _index) {
    index = _index;
  }
}

class NavbarBloc extends Bloc<NavbarEvent, int> {
  NavbarBloc(int initialState) : super(initialState);

  @override
  Stream<int> mapEventToState(NavbarEvent event) async* {
    if (event is SetNavbar)
      yield event.index!;
    else
      yield state;
  }
}
