import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Service/MonitorAbsensi/monitorAbsenApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class MonitorAbsenEvent {
  BuildContext? context;
  String? konteks;
  String? limit;
}

abstract class MonitorAbsenState {
  List<DataMonitorAbsen>? dataMonitorAbsen;
  String? jenis_data;
}

class GetMonitorAbsenEvent extends MonitorAbsenEvent {
  GetMonitorAbsenEvent(BuildContext _context, String _konteks, String _limit) {
    context = _context;
    konteks = _konteks;
    limit = _limit;
  }
}

class loadMoreEvent extends MonitorAbsenEvent {
  late ScrollController scrollController;
  loadMoreEvent(ScrollController _scrollController, String _konteks,String _limit) {
    scrollController = _scrollController;
    konteks = _konteks;
    limit = _limit;
  }
}

class LoadMoreProgressState extends MonitorAbsenState {
  LoadMoreProgressState(List<DataMonitorAbsen>? _data) {
    dataMonitorAbsen = _data;
  }
}

class SuccessMonitorAbsenState extends MonitorAbsenState {
  SuccessMonitorAbsenState(List<DataMonitorAbsen>? _dataMonitorAbsen,String _jenis_data) {
    dataMonitorAbsen = _dataMonitorAbsen;
    jenis_data = _jenis_data;
  }
}

class ProgressMonitorAbsenState extends MonitorAbsenState {}

class ErrorMonitorAbsenState extends MonitorAbsenState {}

class MonitorAbsenBloc extends Bloc<MonitorAbsenEvent, MonitorAbsenState> {
  MonitorAbsenBloc(MonitorAbsenState initialState) : super(initialState);
  List<DataMonitorAbsen>? dataMonitorAbsen;
  String? jenis_data;
  int offset = 0;
  int limit = ServerInfo.limit;
  @override
  Stream<MonitorAbsenState> mapEventToState(MonitorAbsenEvent event) async* {
    if (event is GetMonitorAbsenEvent) {
      offset = 0;
      debugPrint(event.konteks! + ' konteks');
      debugPrint(offset.toString());
      yield ProgressMonitorAbsenState();
      MonitorabsensiRespon data = await MonitorAbsenApi()
          .getDataMonitorAbsen(event.konteks!, offset, event.limit!);
      if (data.success!) {
        dataMonitorAbsen = data.data;
        jenis_data=data.jenis_data;
        yield SuccessMonitorAbsenState(dataMonitorAbsen,jenis_data!);
      } else {
        yield ErrorMonitorAbsenState();
      }
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >=
              event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(dataMonitorAbsen);
        MonitorabsensiRespon data = await MonitorAbsenApi()
            .getDataMonitorAbsen(event.konteks!, offset, event.limit!);
        if (data.success!) {
          dataMonitorAbsen!.addAll(data.data!);
          jenis_data=jenis_data;
        }
        yield SuccessMonitorAbsenState(dataMonitorAbsen,jenis_data!);
      }
    }
  }
}
