import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetDataPengajuanKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class PengajuanPerformanceIndikatorKpiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class PengajuanPerformanceIndikator
    extends PengajuanPerformanceIndikatorKpiEvent {
  ModelPengajuanPerformanceIndikator modelpengajuanPerformanceIndikator;
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  PengajuanPerformanceIndikator(
      this.modelpengajuanPerformanceIndikator, this.context, this.scaffoldKey);
}

class UpdatePengajuanPerformanceIndicator
    extends PengajuanPerformanceIndikatorKpiEvent {
  ModelPengajuanPerformanceIndikator modelpengajuanPerformanceIndikator;
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  UpdatePengajuanPerformanceIndicator(
      this.modelpengajuanPerformanceIndikator, this.context, this.scaffoldKey);
}

class DeletePengajuanPerformanceIndicator
    extends PengajuanPerformanceIndikatorKpiEvent {
  ModelPengajuanPerformanceIndikator modelpengajuanPerformanceIndikator;
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
  DeletePengajuanPerformanceIndicator(
      this.modelpengajuanPerformanceIndikator, this.context, this.scaffoldKey);
}

abstract class PengajuanPerformanceIndikatorState {}

class PengajuanPerformanceIndikatorProgress
    extends PengajuanPerformanceIndikatorState {}

class PengajuanPerformanceIndikatorError
    extends PengajuanPerformanceIndikatorState {}

class PengajuanPerformanceIndikatorBloc extends Bloc<
    PengajuanPerformanceIndikatorKpiEvent, PengajuanPerformanceIndikatorState> {
  PengajuanPerformanceIndikatorBloc(
      PengajuanPerformanceIndikatorState initialState)
      : super(initialState);

  @override
  Stream<PengajuanPerformanceIndikatorState> mapEventToState(
      PengajuanPerformanceIndikatorKpiEvent event) async* {
    if (event is PengajuanPerformanceIndikator) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .tambahPengajuanIndikator(event.modelpengajuanPerformanceIndikator);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        BlocProvider.of<GetDataPengajuanKpiTeamBloc>(event.context!).add(
            GetDataPegajuanKpiTeam(
                event.context!,
                event.modelpengajuanPerformanceIndikator.karyawan,
                event.modelpengajuanPerformanceIndikator.idCompany,
                event.modelpengajuanPerformanceIndikator.bulan,
                event.modelpengajuanPerformanceIndikator.tahun));
      }
    } else if (event is UpdatePengajuanPerformanceIndicator) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .updatePengajuanIndikator(event.modelpengajuanPerformanceIndikator);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        BlocProvider.of<GetDataPengajuanKpiTeamBloc>(event.context!).add(
            GetDataPegajuanKpiTeam(
                event.context!,
                event.modelpengajuanPerformanceIndikator.karyawan,
                event.modelpengajuanPerformanceIndikator.idCompany,
                event.modelpengajuanPerformanceIndikator.bulan,
                event.modelpengajuanPerformanceIndikator.tahun));
      }
    } else if (event is DeletePengajuanPerformanceIndicator) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await KpiApi()
          .deletePengajuanIndikator(event.modelpengajuanPerformanceIndikator);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        BlocProvider.of<NavigatorBloc>(event.context!)
            .add(NavigatePop(event.context));
        BlocProvider.of<GetDataPengajuanKpiTeamBloc>(event.context!).add(
            GetDataPegajuanKpiTeam(
                event.context!,
                event.modelpengajuanPerformanceIndikator.karyawan,
                event.modelpengajuanPerformanceIndikator.idCompany,
                event.modelpengajuanPerformanceIndikator.bulan,
                event.modelpengajuanPerformanceIndikator.tahun));
      }
    }
  }
}
