import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mListKpiTeam.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';

abstract class GetListKpiTeamEvent {}

class GetDataListKpiTeam extends GetListKpiTeamEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiTeam(this.modelFilter);
}

class GetDataListKpiPengajuanTeam extends GetListKpiTeamEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiPengajuanTeam(this.modelFilter);
}

class GetDataListKpiApprovedTeam extends GetListKpiTeamEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiApprovedTeam(this.modelFilter);
}

class GetDataListKpiDraftTeam extends GetListKpiTeamEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiDraftTeam(this.modelFilter);
}

abstract class DataListKpiTeamState {
  List<DataKpiTeam>? data;
}

class DataListKpiTeamProgressState extends DataListKpiTeamState {}

class GetListKpiTeamSuccessState extends DataListKpiTeamState {
  GetListKpiTeamSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetDataListKpiPengajuanTeamSuccessState extends DataListKpiTeamState {
  GetDataListKpiPengajuanTeamSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetDataListKpiApprovedTeamSuccessState extends DataListKpiTeamState {
  GetDataListKpiApprovedTeamSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetDataListKpiDraftTeamSuccessState extends DataListKpiTeamState {
  GetDataListKpiDraftTeamSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class ListKpiErrorState extends DataListKpiTeamState {}

class GetListkpiTeamBloc
    extends Bloc<GetListKpiTeamEvent, DataListKpiTeamState> {
  GetListKpiTeamRespon? dataRespon;
  List<DataKpiTeam>? listDataKpiTeam;

  GetListkpiTeamBloc(DataListKpiTeamState initialState) : super(initialState);

  @override
  Stream<DataListKpiTeamState> mapEventToState(
      GetListKpiTeamEvent event) async* {
    if (event is GetDataListKpiTeam) {
      yield DataListKpiTeamProgressState();
      dataRespon = await KpiApi().getListKpiTeam(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpiTeam = dataRespon!.data;
        yield GetListKpiTeamSuccessState(listDataKpiTeam);
      } else {
        yield ListKpiErrorState();
      }
    }
  }
}

class GetDataListKpiPengajuanTeamBloc
    extends Bloc<GetListKpiTeamEvent, DataListKpiTeamState> {
  GetDataListKpiPengajuanTeamBloc(DataListKpiTeamState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiTeamState> mapEventToState(
      GetListKpiTeamEvent event) async* {
    if (event is GetDataListKpiPengajuanTeam) {
      yield DataListKpiTeamProgressState();
      final dataRespon = await KpiApi().getListKpiTeam(event.modelFilter!);
      if (dataRespon.success!) {
        yield GetDataListKpiPengajuanTeamSuccessState(dataRespon.data);
      } else {
        yield ListKpiErrorState();
      }
    }
  }
}

class GetDataListKpiApprovedTeamBloc
    extends Bloc<GetListKpiTeamEvent, DataListKpiTeamState> {
  GetDataListKpiApprovedTeamBloc(DataListKpiTeamState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiTeamState> mapEventToState(
      GetListKpiTeamEvent event) async* {
    if (event is GetDataListKpiApprovedTeam) {
      yield DataListKpiTeamProgressState();
      final dataRespon = await KpiApi().getListKpiTeam(event.modelFilter!);
      if (dataRespon.success!) {
        yield GetDataListKpiApprovedTeamSuccessState(dataRespon.data);
      } else {
        yield ListKpiErrorState();
      }
    }
  }
}

class GetDataListKpiDraftTeamBloc
    extends Bloc<GetListKpiTeamEvent, DataListKpiTeamState> {
  GetDataListKpiDraftTeamBloc(DataListKpiTeamState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiTeamState> mapEventToState(
      GetListKpiTeamEvent event) async* {
    if (event is GetDataListKpiDraftTeam) {
      yield DataListKpiTeamProgressState();
      final dataRespon = await KpiApi().getListKpiTeam(event.modelFilter!);
      if (dataRespon.success!) {
        yield GetDataListKpiDraftTeamSuccessState(dataRespon.data);
      } else {
        yield ListKpiErrorState();
      }
    }
  }
}
