import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpiWithBobot.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class GetDataPengajuanKpiTeamEvent {
  BuildContext? context;
}

class GetDataPegajuanKpiTeam extends GetDataPengajuanKpiTeamEvent {
  String? id_karyawan;
  String? id_company;
  int? bulan;
  int? tahun;
  GetDataPegajuanKpiTeam(BuildContext _context, this.id_karyawan,
      this.id_company, this.bulan, this.tahun) {
    context = _context;
  }
}

abstract class GetDataPengajuanKpiTeamState {
  DataPengajuan? data;
}

class DataPengajuanKpiTeamProgressState extends GetDataPengajuanKpiTeamState {}

class GetDataPengajuanKpiTeamSuccessState extends GetDataPengajuanKpiTeamState {
  GetDataPengajuanKpiTeamSuccessState(DataPengajuan? _data) {
    data = _data;
  }
}

class DataPengajuanKpiErrorState extends GetDataPengajuanKpiTeamState {}

class GetDataPengajuanKpiTeamBloc
    extends Bloc<GetDataPengajuanKpiTeamEvent, GetDataPengajuanKpiTeamState> {
  DataPengajuanKpiWithBobotRespon? dataRespon;
  DataPengajuan? dataPengajuan;
  String? id_karyawan;
  String? id_company;
  int? bulan;
  int? tahun;

  GetDataPengajuanKpiTeamBloc(GetDataPengajuanKpiTeamState initialState)
      : super(initialState);

  @override
  Stream<GetDataPengajuanKpiTeamState> mapEventToState(
      GetDataPengajuanKpiTeamEvent event) async* {
    if (event is GetDataPegajuanKpiTeam) {
      yield DataPengajuanKpiTeamProgressState();
      dataRespon = await KpiApi().getDataPengajuanKpiTeam(
          event.id_karyawan, event.id_company, event.bulan, event.tahun);
      if (dataRespon!.success!) {
        dataPengajuan = dataRespon!.data;
        yield GetDataPengajuanKpiTeamSuccessState(dataPengajuan);
      }
    }
  }
}
