import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiSaya/GetListKpiSayaBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart' as mpengajuan;
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';

abstract class TerimaKpiKpiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class TerimaApprovalKpi extends TerimaKpiKpiEvent {
  mpengajuan.ParsingModelKaryawan data;
  String keterangan;
  BuildContext? context;
  TerimaApprovalKpi(this.data, this.keterangan, this.context);
}

abstract class TerimaApprovalKpiState {}

class TerimaApprovalKpiProgress extends TerimaApprovalKpiState {}

class TerimaApprovalKpiSayaKpiError extends TerimaApprovalKpiState {}

class TerimaApprovalKpiBloc
    extends Bloc<TerimaKpiKpiEvent, TerimaApprovalKpiState> {
  TerimaApprovalKpiBloc(TerimaApprovalKpiState initialState)
      : super(initialState);

  @override
  Stream<TerimaApprovalKpiState> mapEventToState(
      TerimaKpiKpiEvent event) async* {
    if (event is TerimaApprovalKpi) {
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon =
          await KpiApi().terimaAppovalKpi(event.data, event.keterangan);
      ProgressDialogDelayed.hide(pd);
      showSnackBarDelayed(
          event.scaffoldKey, basicRespon.message, event.context);
      if (basicRespon.success!) {
        if (basicRespon.success == true) {
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          BlocProvider.of<NavigatorBloc>(event.context!)
              .add(NavigatePop(event.context));
          final monthYear = new DateTime(event.data.tahun!,event.data.bulan!,DateTime.now().day);
          BlocProvider.of<GetListKpiApproveSayaBloc>(event.context!).add(
                      GetDataListKpiApproveSaya(ModelFilterKpi(
                          status: '4', monthYear: monthYear)));
        }
      }
    }
  }
}
