import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mListKpiTeam.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';

abstract class GetListKpiSayaEvent {}

class GetDataListKpiSaya extends GetListKpiSayaEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiSaya(this.modelFilter);
}

class GetDataListKpiPengajuanSaya extends GetListKpiSayaEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiPengajuanSaya(this.modelFilter);
}

class GetDataListKpiApproveSaya extends GetListKpiSayaEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiApproveSaya(this.modelFilter);
}

class GetDataListKpiDiterimaSaya extends GetListKpiSayaEvent {
  ModelFilterKpi? modelFilter;
  GetDataListKpiDiterimaSaya(this.modelFilter);
}

abstract class DataListKpiSayaState {
  List<DataKpiTeam>? data;
}

class DataListKpiSayaProgressState extends DataListKpiSayaState {}

class DataListKpiSayaErrorState extends DataListKpiSayaState {}

class GetListKpiSayaSuccessState extends DataListKpiSayaState {
  GetListKpiSayaSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetListKpiPengajuanSayaSuccessState extends DataListKpiSayaState {
  GetListKpiPengajuanSayaSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetListKpiApproveSayaSuccessState extends DataListKpiSayaState {
  GetListKpiApproveSayaSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetListKpiDiterimaSayaSuccessState extends DataListKpiSayaState {
  GetListKpiDiterimaSayaSuccessState(List<DataKpiTeam>? _data) {
    data = _data;
  }
}

class GetListKpiSayaBloc
    extends Bloc<GetListKpiSayaEvent, DataListKpiSayaState> {
  GetListKpiTeamRespon? dataRespon;
  List<DataKpiTeam>? listDataKpiTeam;

  GetListKpiSayaBloc(DataListKpiSayaState initialState) : super(initialState);

  @override
  Stream<DataListKpiSayaState> mapEventToState(
      GetListKpiSayaEvent event) async* {
    if (event is GetDataListKpiSaya) {
      yield DataListKpiSayaProgressState();
      dataRespon = await KpiApi().getListKpiSaya(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpiTeam = dataRespon!.data;
        yield GetListKpiSayaSuccessState(listDataKpiTeam);
      } else {
        yield DataListKpiSayaErrorState();
      }
    }
  }
}

class GetListKpiPengajuanSayaBloc
    extends Bloc<GetListKpiSayaEvent, DataListKpiSayaState> {
  GetListKpiTeamRespon? dataRespon;
  List<DataKpiTeam>? listDataKpiTeam;

  GetListKpiPengajuanSayaBloc(DataListKpiSayaState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiSayaState> mapEventToState(
      GetListKpiSayaEvent event) async* {
    if (event is GetDataListKpiPengajuanSaya) {
      yield DataListKpiSayaProgressState();
      dataRespon = await KpiApi().getListKpiSaya(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpiTeam = dataRespon!.data;
        yield GetListKpiPengajuanSayaSuccessState(listDataKpiTeam);
      } else {
        yield DataListKpiSayaErrorState();
      }
    }
  }
}

class GetListKpiApproveSayaBloc
    extends Bloc<GetListKpiSayaEvent, DataListKpiSayaState> {
  GetListKpiTeamRespon? dataRespon;
  List<DataKpiTeam>? listDataKpiTeam;

  GetListKpiApproveSayaBloc(DataListKpiSayaState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiSayaState> mapEventToState(
      GetListKpiSayaEvent event) async* {
    if (event is GetDataListKpiApproveSaya) {
      yield DataListKpiSayaProgressState();
      dataRespon = await KpiApi().getListKpiSaya(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpiTeam = dataRespon!.data;
        yield GetListKpiApproveSayaSuccessState(listDataKpiTeam);
      } else {
        yield DataListKpiSayaErrorState();
      }
    }
  }
}

class GetListKpiDiterimaSayaBloc
    extends Bloc<GetListKpiSayaEvent, DataListKpiSayaState> {
  GetListKpiTeamRespon? dataRespon;
  List<DataKpiTeam>? listDataKpiTeam;

  GetListKpiDiterimaSayaBloc(DataListKpiSayaState initialState)
      : super(initialState);

  @override
  Stream<DataListKpiSayaState> mapEventToState(
      GetListKpiSayaEvent event) async* {
    if (event is GetDataListKpiDiterimaSaya) {
      yield DataListKpiSayaProgressState();
      dataRespon = await KpiApi().getListKpiSaya(event.modelFilter!);
      if (dataRespon!.success!) {
        listDataKpiTeam = dataRespon!.data;
        yield GetListKpiDiterimaSayaSuccessState(listDataKpiTeam);
      } else {
        yield DataListKpiSayaErrorState();
      }
    }
  }
}
