import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataNilaiIndividu.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class GetDataPengajuanNilaiIndividuEvent {
  BuildContext? context;
}

class GetDataPengajuanNilaiIndividu extends GetDataPengajuanNilaiIndividuEvent {
  ParsingModelKaryawan dataParsing;
  GetDataPengajuanNilaiIndividu(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

class GetDataNilaiIndividu extends GetDataPengajuanNilaiIndividuEvent {
  ParsingModelKaryawan dataParsing;
  GetDataNilaiIndividu(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

abstract class GetDataPengajuanNilaiIndividuState {
  DataNilaiIndividu? data;
}

class DataPengajuanNilaiIndividuProgressState
    extends GetDataPengajuanNilaiIndividuState {}

class GetDataPengajuanNilaiIndividuSuccessState
    extends GetDataPengajuanNilaiIndividuState {
  GetDataPengajuanNilaiIndividuSuccessState(DataNilaiIndividu? _data) {
    data = _data;
  }
}

class GetDataNilaiIndividuSuccessState
    extends GetDataPengajuanNilaiIndividuState {
  GetDataNilaiIndividuSuccessState(DataNilaiIndividu? _data) {
    data = _data;
  }
}

class DataPengajuanKpiErrorState extends GetDataPengajuanNilaiIndividuState {}

class GetDataPengajuanNilaiIndividuBloc extends Bloc<
    GetDataPengajuanNilaiIndividuEvent, GetDataPengajuanNilaiIndividuState> {
  DataPengajuanNilaiIndividu? dataRespon;
  DataNilaiIndividu? DataPengajuan;

  GetDataPengajuanNilaiIndividuBloc(
      GetDataPengajuanNilaiIndividuState initialState)
      : super(initialState);

  @override
  Stream<GetDataPengajuanNilaiIndividuState> mapEventToState(
      GetDataPengajuanNilaiIndividuEvent event) async* {
    if (event is GetDataPengajuanNilaiIndividu) {
      yield DataPengajuanNilaiIndividuProgressState();
      dataRespon =
          await KpiApi().getDataPengajuanNilaiIndividu(event.dataParsing);
      if (dataRespon!.success!) {
        DataPengajuan = dataRespon!.data;
        yield GetDataPengajuanNilaiIndividuSuccessState(DataPengajuan);
      } else {
        yield DataPengajuanKpiErrorState();
      }
    } else if (event is GetDataNilaiIndividu) {
      yield DataPengajuanNilaiIndividuProgressState();
      dataRespon = await KpiApi().getDataNilaiIndividu(event.dataParsing);
      if (dataRespon!.success!) {
        DataPengajuan = dataRespon!.data;
        yield GetDataNilaiIndividuSuccessState(DataPengajuan);
      } else {
        yield DataPengajuanKpiErrorState();
      }
    }
  }

  // Stream<GetDataPengajuanNilaiIndividuState> mapEventToState(
  //     GetDataPengajuanNilaiIndividuEvent event) async* {
  //   if (event is GetDataPengajuanNilaiIndividu) {
  //     yield DataPengajuanNilaiIndividuProgressState();
  //     dataRespon =
  //         await KpiApi().getDataPengajuanNilaiIndividu(event.dataParsing);
  //     if (dataRespon!.success!) {
  //       DataPengajuan = dataRespon!.data;
  //       yield GetDataPengajuanNilaiIndividuSuccessState(DataPengajuan);
  //     } else {
  //       yield DataPengajuanKpiErrorState();
  //     }
  //   } else if (event is GetDataNilaiIndividu) {
  //     yield DataPengajuanNilaiIndividuProgressState();
  //     dataRespon = await KpiApi().getDataNilaiIndividu(event.dataParsing);
  //     if (dataRespon!.success!) {
  //       DataPengajuan = dataRespon!.data;
  //       yield GetDataPengajuanNilaiIndividuSuccessState(DataPengajuan);
  //     } else {
  //       yield DataPengajuanKpiErrorState();
  //     }
  //   }
  // }
}
