import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKepribadian.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Service/kpiApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';

abstract class GetDataPengajuanAspekKepribadianEvent {
  BuildContext? context;
}

class GetDataPengajuanAspekKepribadian
    extends GetDataPengajuanAspekKepribadianEvent {
  ParsingModelKaryawan dataParsing;
  GetDataPengajuanAspekKepribadian(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

class GetDataAspekKepribadian extends GetDataPengajuanAspekKepribadianEvent {
  ParsingModelKaryawan dataParsing;
  GetDataAspekKepribadian(BuildContext _context, this.dataParsing) {
    context = _context;
  }
}

abstract class GetDataPengajuanAspekKepribadianState {
  List<DataAspekKepribadian>? data;
}

class DataPengajuanAspekKepribadianProgressState
    extends GetDataPengajuanAspekKepribadianState {}

class GetDataPengajuanAspekKepribadianSuccessState
    extends GetDataPengajuanAspekKepribadianState {
  GetDataPengajuanAspekKepribadianSuccessState(
      List<DataAspekKepribadian>? _data) {
    data = _data;
  }
}

class DataPengajuanKpiErrorState
    extends GetDataPengajuanAspekKepribadianState {}

class GetDataPengajuanAspekKepribadianBloc extends Bloc<
    GetDataPengajuanAspekKepribadianEvent,
    GetDataPengajuanAspekKepribadianState> {
  DataPengajuanAspekKepribadian? dataRespon;
  List<DataAspekKepribadian>? listDataPengajuan;

  GetDataPengajuanAspekKepribadianBloc(
      GetDataPengajuanAspekKepribadianState initialState)
      : super(initialState);

  @override
  Stream<GetDataPengajuanAspekKepribadianState> mapEventToState(
      GetDataPengajuanAspekKepribadianEvent event) async* {
    if (event is GetDataPengajuanAspekKepribadian) {
      yield DataPengajuanAspekKepribadianProgressState();
      dataRespon =
          await KpiApi().getDataPengajuanAspekKepribadian(event.dataParsing);
      if (dataRespon!.success!) {
        listDataPengajuan = dataRespon!.data;
        yield GetDataPengajuanAspekKepribadianSuccessState(listDataPengajuan);
      } else {
        yield DataPengajuanKpiErrorState();
      }
    } else if (event is GetDataAspekKepribadian) {
      yield DataPengajuanAspekKepribadianProgressState();
      dataRespon = await KpiApi().getDataAspekKepribadian(event.dataParsing);
      if (dataRespon!.success!) {
        listDataPengajuan = dataRespon!.data;
        yield GetDataPengajuanAspekKepribadianSuccessState(listDataPengajuan);
      }
    } else {
      yield DataPengajuanKpiErrorState();
    }
  }
}
