import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Service/dropdownApi.dart';
import 'package:bloc/bloc.dart';

abstract class DropdownSalesBawahanEvent {}

class GetDataDropdownSalesBawahan extends DropdownSalesBawahanEvent {
  String? idGroupM;
  GetDataDropdownSalesBawahan(String _idGroupM){
    idGroupM = _idGroupM;
  }
}

class SelectDataDropdownSalesBawahan extends DropdownSalesBawahanEvent {
  DataDropdown selectedValue;
  SelectDataDropdownSalesBawahan(this.selectedValue);
}

abstract class DropdownSalesBawahanState {}

class DropdownSalesBawahanProgressState extends DropdownSalesBawahanState {}

class DropdownSalesBawahanSuccessState extends DropdownSalesBawahanState {
  DropdownRespon dropdownRespon;
  DataDropdown? selectedValue;
  DropdownSalesBawahanSuccessState(this.dropdownRespon, this.selectedValue);
}

class DropdownSalesBawahanErrorState extends DropdownSalesBawahanState {}

class DropdownSalesBawahanBloc extends Bloc<DropdownSalesBawahanEvent, DropdownSalesBawahanState> {
  DropdownSalesBawahanBloc(DropdownSalesBawahanState initialState) : super(initialState);
  DataDropdown? selectedValue;
  DropdownRespon? dropdownRespon;

  @override
  Stream<DropdownSalesBawahanState> mapEventToState(DropdownSalesBawahanEvent event) async* {
    // TODO: implement mapEventToState
    if (event is GetDataDropdownSalesBawahan) {
      yield DropdownSalesBawahanProgressState();
      selectedValue = null;
      dropdownRespon = await DropdownApi().getPegawaiBawahan("", event.idGroupM, 0);
      if (dropdownRespon!.data != null)
        yield DropdownSalesBawahanSuccessState(dropdownRespon!, null);
      else
        yield DropdownSalesBawahanErrorState();
    } else if (event is SelectDataDropdownSalesBawahan) {
      selectedValue = event.selectedValue;
      yield DropdownSalesBawahanSuccessState(dropdownRespon!, selectedValue!);
    }
  }
}
